/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter.xml;

import infra.beans.TypeMismatchException;
import infra.http.HttpHeaders;
import infra.http.MediaType;
import infra.http.converter.xml.AbstractXmlHttpMessageConverter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.oxm.Marshaller;
import infra.oxm.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;

public class MarshallingHttpMessageConverter
extends AbstractXmlHttpMessageConverter<Object> {
    @Nullable
    private Marshaller marshaller;
    @Nullable
    private Unmarshaller unmarshaller;

    public MarshallingHttpMessageConverter() {
    }

    public MarshallingHttpMessageConverter(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"Marshaller is required");
        this.marshaller = marshaller;
        if (marshaller instanceof Unmarshaller) {
            Unmarshaller _unmarshaller;
            this.unmarshaller = _unmarshaller = (Unmarshaller)marshaller;
        }
    }

    public MarshallingHttpMessageConverter(Marshaller marshaller, Unmarshaller unmarshaller) {
        Assert.notNull((Object)marshaller, (String)"Marshaller is required");
        Assert.notNull((Object)unmarshaller, (String)"Unmarshaller is required");
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    @Override
    public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.canRead(mediaType) && this.unmarshaller != null && this.unmarshaller.supports(clazz);
    }

    @Override
    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.canWrite(mediaType) && this.marshaller != null && this.marshaller.supports(clazz);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object readFromSource(Class<?> clazz, HttpHeaders headers, Source source) throws Exception {
        Assert.state((this.unmarshaller != null ? 1 : 0) != 0, (String)"Property 'unmarshaller' is required");
        Object result = this.unmarshaller.unmarshal(source);
        if (!clazz.isInstance(result)) {
            throw new TypeMismatchException(result, clazz);
        }
        return result;
    }

    @Override
    protected void writeToResult(Object o, HttpHeaders headers, Result result) throws Exception {
        Assert.state((this.marshaller != null ? 1 : 0) != 0, (String)"Property 'marshaller' is required");
        this.marshaller.marshal(o, result);
    }

    @Override
    protected boolean supportsRepeatableWrites(Object o) {
        return true;
    }
}

