/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter.xml;

import infra.http.HttpHeaders;
import infra.http.HttpInputMessage;
import infra.http.HttpOutputMessage;
import infra.http.MediaType;
import infra.http.converter.AbstractHttpMessageConverter;
import infra.http.converter.HttpMessageConversionException;
import infra.http.converter.HttpMessageNotReadableException;
import infra.http.converter.HttpMessageNotWritableException;
import infra.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public abstract class AbstractXmlHttpMessageConverter<T>
extends AbstractHttpMessageConverter<T> {
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    protected AbstractXmlHttpMessageConverter() {
        super(MediaType.APPLICATION_XML, MediaType.TEXT_XML, new MediaType("application", "*+xml"));
    }

    @Override
    public final T readInternal(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        try {
            InputStream inputStream = StreamUtils.nonClosing((InputStream)inputMessage.getBody());
            return this.readFromSource(clazz, inputMessage.getHeaders(), new StreamSource(inputStream));
        }
        catch (HttpMessageConversionException | IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new HttpMessageNotReadableException("Could not unmarshal to [" + clazz + "]: " + ex, ex, inputMessage);
        }
    }

    @Override
    protected final void writeInternal(T t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try {
            this.writeToResult(t, outputMessage.getHeaders(), new StreamResult(outputMessage.getBody()));
        }
        catch (HttpMessageConversionException | IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new HttpMessageNotWritableException("Could not marshal [" + t + "]: " + ex.getMessage(), ex);
        }
    }

    protected void transform(Source source, Result result) throws TransformerException {
        this.transformerFactory.newTransformer().transform(source, result);
    }

    protected abstract T readFromSource(Class<? extends T> var1, HttpHeaders var2, Source var3) throws Exception;

    protected abstract void writeToResult(T var1, HttpHeaders var2, Result var3) throws Exception;
}

