/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.util.JsonFormat;
import infra.http.HttpHeaders;
import infra.http.HttpInputMessage;
import infra.http.HttpOutputMessage;
import infra.http.MediaType;
import infra.http.converter.AbstractHttpMessageConverter;
import infra.http.converter.HttpMessageConversionException;
import infra.http.converter.HttpMessageNotReadableException;
import infra.http.converter.HttpMessageNotWritableException;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.util.ClassUtils;
import infra.util.ConcurrentReferenceHashMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;

public class ProtobufHttpMessageConverter
extends AbstractHttpMessageConverter<MessageOrBuilder> {
    public static final MediaType PROTOBUF = new MediaType("application", "x-protobuf", Constant.DEFAULT_CHARSET);
    public static final String X_PROTOBUF_SCHEMA_HEADER = "X-Protobuf-Schema";
    public static final String X_PROTOBUF_MESSAGE_HEADER = "X-Protobuf-Message";
    private static final ConcurrentReferenceHashMap<Class<?>, Method> methodCache = new ConcurrentReferenceHashMap();
    final ExtensionRegistry extensionRegistry;
    @Nullable
    private final ProtobufFormatSupport protobufFormatSupport;
    private boolean populateProtoHeader = true;

    public ProtobufHttpMessageConverter() {
        this((ProtobufFormatSupport)null, (ExtensionRegistry)null);
    }

    public ProtobufHttpMessageConverter(ExtensionRegistry extensionRegistry) {
        this(null, extensionRegistry);
    }

    ProtobufHttpMessageConverter(@Nullable ProtobufFormatSupport formatSupport, @Nullable ExtensionRegistry extensionRegistry) {
        MediaType[] mediaTypeArray;
        this.protobufFormatSupport = formatSupport != null ? formatSupport : (ClassUtils.isPresent((String)"com.google.protobuf.util.JsonFormat", (ClassLoader)this.getClass().getClassLoader()) ? new ProtobufJavaUtilSupport(null, null) : null);
        if (this.protobufFormatSupport != null) {
            mediaTypeArray = this.protobufFormatSupport.supportedMediaTypes();
        } else {
            MediaType[] mediaTypeArray2 = new MediaType[2];
            mediaTypeArray2[0] = PROTOBUF;
            mediaTypeArray = mediaTypeArray2;
            mediaTypeArray2[1] = MediaType.TEXT_PLAIN;
        }
        this.setSupportedMediaTypes(Arrays.asList(mediaTypeArray));
        this.extensionRegistry = extensionRegistry == null ? ExtensionRegistry.newInstance() : extensionRegistry;
    }

    public void setPopulateProtoHeader(boolean populateProtoHeader) {
        this.populateProtoHeader = populateProtoHeader;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return MessageOrBuilder.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
        return Message.class.isAssignableFrom(clazz) && this.canRead(mediaType);
    }

    @Override
    protected MediaType getDefaultContentType(MessageOrBuilder message) {
        return PROTOBUF;
    }

    @Override
    protected Message readInternal(Class<? extends MessageOrBuilder> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        if (contentType == null) {
            contentType = PROTOBUF;
        }
        Message.Builder builder = this.getMessageBuilder(clazz);
        if (PROTOBUF.isCompatibleWith(contentType)) {
            builder.mergeFrom(inputMessage.getBody(), (ExtensionRegistryLite)this.extensionRegistry);
        } else if (MediaType.TEXT_PLAIN.isCompatibleWith(contentType)) {
            Charset charset = ProtobufHttpMessageConverter.getCharset(contentType);
            InputStreamReader reader = new InputStreamReader(inputMessage.getBody(), charset);
            TextFormat.merge((Readable)reader, (ExtensionRegistry)this.extensionRegistry, (Message.Builder)builder);
        } else if (this.protobufFormatSupport != null) {
            Charset charset = ProtobufHttpMessageConverter.getCharset(contentType);
            this.protobufFormatSupport.merge(inputMessage, charset, contentType, this.extensionRegistry, builder);
        }
        return builder.build();
    }

    private Message.Builder getMessageBuilder(Class<?> clazz) {
        try {
            Method method = (Method)methodCache.get(clazz);
            if (method == null) {
                method = clazz.getMethod("newBuilder", new Class[0]);
                methodCache.put(clazz, (Object)method);
            }
            return (Message.Builder)method.invoke(clazz, new Object[0]);
        }
        catch (Exception ex) {
            throw new HttpMessageConversionException("Invalid Protobuf Message type: no invocable newBuilder() method on " + clazz, ex);
        }
    }

    @Override
    protected boolean canWrite(@Nullable MediaType mediaType) {
        return super.canWrite(mediaType) || this.protobufFormatSupport != null && this.protobufFormatSupport.supportsWriteOnly(mediaType);
    }

    @Override
    protected void writeInternal(MessageOrBuilder message, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        MediaType contentType = outputMessage.getHeaders().getContentType();
        if (contentType == null) {
            contentType = this.getDefaultContentType(message);
            Assert.state((contentType != null ? 1 : 0) != 0, (String)"No content type");
        }
        if (PROTOBUF.isCompatibleWith(contentType)) {
            if (this.populateProtoHeader) {
                this.setProtoHeader(outputMessage, message);
            }
            if (message instanceof Message.Builder) {
                Message.Builder builder = (Message.Builder)message;
                builder.build().writeTo(outputMessage.getBody());
            } else {
                ((Message)message).writeTo(outputMessage.getBody());
            }
        } else if (MediaType.TEXT_PLAIN.isCompatibleWith(contentType)) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputMessage.getBody(), ProtobufHttpMessageConverter.getCharset(contentType));
            TextFormat.printer().print(message, (Appendable)outputStreamWriter);
            outputStreamWriter.flush();
        } else if (this.protobufFormatSupport != null) {
            this.protobufFormatSupport.print(message, outputMessage, contentType);
        }
    }

    private static Charset getCharset(MediaType contentType) {
        Charset charset = contentType.getCharset();
        if (charset == null) {
            charset = Constant.DEFAULT_CHARSET;
        }
        return charset;
    }

    protected void setProtoHeader(HttpOutputMessage response, MessageOrBuilder message) {
        HttpHeaders headers = response.getHeaders();
        Descriptors.Descriptor descriptorForType = message.getDescriptorForType();
        headers.setOrRemove(X_PROTOBUF_SCHEMA_HEADER, descriptorForType.getFile().getName());
        headers.setOrRemove(X_PROTOBUF_MESSAGE_HEADER, descriptorForType.getFullName());
    }

    @Override
    protected boolean supportsRepeatableWrites(MessageOrBuilder message) {
        return true;
    }

    static interface ProtobufFormatSupport {
        public MediaType[] supportedMediaTypes();

        public boolean supportsWriteOnly(@Nullable MediaType var1);

        public void merge(HttpInputMessage var1, Charset var2, MediaType var3, ExtensionRegistry var4, Message.Builder var5) throws IOException, HttpMessageConversionException;

        public void print(MessageOrBuilder var1, HttpOutputMessage var2, MediaType var3) throws IOException, HttpMessageConversionException;
    }

    static class ProtobufJavaUtilSupport
    implements ProtobufFormatSupport {
        private final JsonFormat.Parser parser;
        private final JsonFormat.Printer printer;

        public ProtobufJavaUtilSupport(@Nullable JsonFormat.Parser parser, @Nullable JsonFormat.Printer printer) {
            this.parser = parser != null ? parser : JsonFormat.parser();
            this.printer = printer != null ? printer : JsonFormat.printer();
        }

        @Override
        public MediaType[] supportedMediaTypes() {
            return new MediaType[]{PROTOBUF, MediaType.TEXT_PLAIN, MediaType.APPLICATION_JSON};
        }

        @Override
        public boolean supportsWriteOnly(@Nullable MediaType mediaType) {
            return false;
        }

        @Override
        public void merge(HttpInputMessage input, Charset charset, MediaType contentType, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException, HttpMessageConversionException {
            if (!contentType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                throw new HttpMessageConversionException("protobuf-java-util does not support parsing " + contentType);
            }
            InputStreamReader reader = new InputStreamReader(input.getBody(), charset);
            this.parser.merge((Reader)reader, builder);
        }

        @Override
        public void print(MessageOrBuilder message, HttpOutputMessage output, MediaType contentType) throws IOException, HttpMessageConversionException {
            if (!contentType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                throw new HttpMessageConversionException("protobuf-java-util does not support printing " + contentType);
            }
            OutputStreamWriter writer = new OutputStreamWriter(output.getBody(), ProtobufHttpMessageConverter.getCharset(contentType));
            this.printer.appendTo(message, (Appendable)writer);
            writer.flush();
        }
    }
}

