/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import infra.http.MediaType;
import infra.http.converter.json.AbstractJackson2HttpMessageConverter;
import infra.http.converter.json.Jackson2ObjectMapperBuilder;
import infra.lang.Nullable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class MappingJackson2HttpMessageConverter
extends AbstractJackson2HttpMessageConverter {
    private static final List<MediaType> problemDetailMediaTypes = Collections.singletonList(MediaType.APPLICATION_PROBLEM_JSON);
    @Nullable
    private String jsonPrefix;

    public MappingJackson2HttpMessageConverter() {
        this((ObjectMapper)Jackson2ObjectMapperBuilder.json().build());
    }

    public MappingJackson2HttpMessageConverter(ObjectMapper objectMapper) {
        super(objectMapper, MediaType.APPLICATION_JSON, new MediaType("application", "*+json"));
    }

    public void setJsonPrefix(@Nullable String jsonPrefix) {
        this.jsonPrefix = jsonPrefix;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.jsonPrefix = prefixJson ? ")]}', " : null;
    }

    @Override
    protected void writePrefix(JsonGenerator generator, Object object) throws IOException {
        if (this.jsonPrefix != null) {
            generator.writeRaw(this.jsonPrefix);
        }
    }

    @Override
    protected List<MediaType> getMediaTypesForProblemDetail() {
        return problemDetailMediaTypes;
    }
}

