/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter.json;

import com.google.gson.Gson;
import infra.http.converter.json.AbstractJsonHttpMessageConverter;
import infra.lang.Assert;
import infra.lang.Nullable;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class GsonHttpMessageConverter
extends AbstractJsonHttpMessageConverter {
    private Gson gson;

    public GsonHttpMessageConverter() {
        this.gson = new Gson();
    }

    public GsonHttpMessageConverter(Gson gson) {
        Assert.notNull((Object)gson, (String)"A Gson instance is required");
        this.gson = gson;
    }

    public void setGson(Gson gson) {
        Assert.notNull((Object)gson, (String)"A Gson instance is required");
        this.gson = gson;
    }

    public Gson getGson() {
        return this.gson;
    }

    @Override
    protected Object readInternal(Type resolvedType, Reader reader) throws Exception {
        return this.getGson().fromJson(reader, resolvedType);
    }

    @Override
    protected void writeInternal(Object object, @Nullable Type type, Writer writer) throws Exception {
        if (type instanceof ParameterizedType) {
            this.getGson().toJson(object, type, (Appendable)writer);
        } else {
            this.getGson().toJson(object, (Appendable)writer);
        }
    }

    @Override
    protected boolean supportsRepeatableWrites(Object o) {
        return true;
    }
}

