/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter.feed;

import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.WireFeedInput;
import com.rometools.rome.io.WireFeedOutput;
import infra.http.HttpInputMessage;
import infra.http.HttpOutputMessage;
import infra.http.MediaType;
import infra.http.converter.AbstractHttpMessageConverter;
import infra.http.converter.HttpMessageNotReadableException;
import infra.http.converter.HttpMessageNotWritableException;
import infra.lang.Constant;
import infra.util.StreamUtils;
import infra.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public abstract class AbstractWireFeedHttpMessageConverter<T extends WireFeed>
extends AbstractHttpMessageConverter<T> {
    protected AbstractWireFeedHttpMessageConverter(MediaType supportedMediaType) {
        super(supportedMediaType);
    }

    @Override
    protected T readInternal(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        WireFeedInput feedInput = new WireFeedInput();
        MediaType contentType = inputMessage.getHeaders().getContentType();
        Charset charset = contentType != null && contentType.getCharset() != null ? contentType.getCharset() : Constant.DEFAULT_CHARSET;
        try {
            InputStream inputStream = StreamUtils.nonClosing((InputStream)inputMessage.getBody());
            InputStreamReader reader = new InputStreamReader(inputStream, charset);
            return (T)feedInput.build((Reader)reader);
        }
        catch (FeedException ex) {
            throw new HttpMessageNotReadableException("Could not read WireFeed: " + ex.getMessage(), ex, inputMessage);
        }
    }

    @Override
    protected void writeInternal(T wireFeed, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Charset charset = StringUtils.isNotEmpty((CharSequence)wireFeed.getEncoding()) ? Charset.forName(wireFeed.getEncoding()) : Constant.DEFAULT_CHARSET;
        MediaType contentType = outputMessage.getHeaders().getContentType();
        if (contentType != null) {
            contentType = contentType.withCharset(charset);
            outputMessage.getHeaders().setContentType(contentType);
        }
        WireFeedOutput feedOutput = new WireFeedOutput();
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputMessage.getBody(), charset);
            feedOutput.output(wireFeed, (Writer)writer);
        }
        catch (FeedException ex) {
            throw new HttpMessageNotWritableException("Could not write WireFeed: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected boolean supportsRepeatableWrites(T t) {
        return true;
    }
}

