/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter;

import infra.http.HttpHeaders;
import infra.http.HttpInputMessage;
import infra.http.HttpOutputMessage;
import infra.http.MediaType;
import infra.http.converter.AbstractHttpMessageConverter;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.util.StreamUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class StringHttpMessageConverter
extends AbstractHttpMessageConverter<String> {
    private static final MediaType APPLICATION_PLUS_JSON = new MediaType("application", "*+json");
    @Nullable
    private volatile List<Charset> availableCharsets;
    private boolean writeAcceptCharset = false;

    public StringHttpMessageConverter() {
        this(Constant.DEFAULT_CHARSET);
    }

    public StringHttpMessageConverter(Charset defaultCharset) {
        super(defaultCharset, MediaType.TEXT_PLAIN, MediaType.ALL);
    }

    public void setWriteAcceptCharset(boolean writeAcceptCharset) {
        this.writeAcceptCharset = writeAcceptCharset;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return String.class == clazz;
    }

    @Override
    protected String readInternal(Class<? extends String> clazz, HttpInputMessage inputMessage) throws IOException {
        Charset charset = this.getContentTypeCharset(inputMessage.getHeaders().getContentType());
        long length = inputMessage.getHeaders().getContentLength();
        byte[] bytes = length >= 0L && length <= Integer.MAX_VALUE ? inputMessage.getBody().readNBytes((int)length) : inputMessage.getBody().readAllBytes();
        return new String(bytes, charset);
    }

    @Override
    protected Long getContentLength(String str, @Nullable MediaType contentType) {
        Charset charset = this.getContentTypeCharset(contentType);
        return str.getBytes(charset).length;
    }

    @Override
    public void addDefaultHeaders(HttpHeaders headers, String s, @Nullable MediaType type) throws IOException {
        String contentTypeString = headers.getFirst("Content-Type");
        if (contentTypeString == null && type != null && type.isConcrete() && (type.isCompatibleWith(MediaType.APPLICATION_JSON) || type.isCompatibleWith(APPLICATION_PLUS_JSON))) {
            headers.setContentType(type);
        }
        super.addDefaultHeaders(headers, s, type);
    }

    @Override
    protected void writeInternal(String str, HttpOutputMessage outputMessage) throws IOException {
        HttpHeaders headers = outputMessage.getHeaders();
        if (this.writeAcceptCharset && headers.get("Accept-Charset") == null) {
            headers.setAcceptCharset(this.getAcceptedCharsets());
        }
        Charset charset = this.getContentTypeCharset(headers.getContentType());
        StreamUtils.copy((String)str, (Charset)charset, (OutputStream)outputMessage.getBody());
    }

    protected List<Charset> getAcceptedCharsets() {
        List<Charset> charsets = this.availableCharsets;
        if (charsets == null) {
            this.availableCharsets = charsets = new ArrayList<Charset>(Charset.availableCharsets().values());
        }
        return charsets;
    }

    private Charset getContentTypeCharset(@Nullable MediaType contentType) {
        Charset charset;
        if (contentType != null) {
            charset = contentType.getCharset();
            if (charset != null) {
                return charset;
            }
            if (contentType.isCompatibleWith(MediaType.APPLICATION_JSON) || contentType.isCompatibleWith(APPLICATION_PLUS_JSON)) {
                return StandardCharsets.UTF_8;
            }
        }
        Assert.state(((charset = this.getDefaultCharset()) != null ? 1 : 0) != 0, (String)"No default charset");
        return charset;
    }

    @Override
    protected boolean supportsRepeatableWrites(String s) {
        return true;
    }
}

