/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter;

import infra.core.io.InputStreamResource;
import infra.core.io.Resource;
import infra.core.io.ResourceRegion;
import infra.http.HttpHeaders;
import infra.http.HttpInputMessage;
import infra.http.HttpOutputMessage;
import infra.http.MediaType;
import infra.http.MediaTypeFactory;
import infra.http.converter.AbstractGenericHttpMessageConverter;
import infra.http.converter.HttpMessageNotReadableException;
import infra.http.converter.HttpMessageNotWritableException;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.MimeTypeUtils;
import infra.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public class ResourceRegionHttpMessageConverter
extends AbstractGenericHttpMessageConverter<Object> {
    public ResourceRegionHttpMessageConverter() {
        super(MediaType.ALL);
    }

    @Override
    protected MediaType getDefaultContentType(Object object) {
        Resource resource = null;
        if (object instanceof ResourceRegion) {
            ResourceRegion resourceRegion = (ResourceRegion)object;
            resource = resourceRegion.getResource();
        } else {
            Collection regions = (Collection)object;
            if (!regions.isEmpty()) {
                resource = ((ResourceRegion)regions.iterator().next()).getResource();
            }
        }
        return MediaTypeFactory.getMediaType(resource).orElse(MediaType.APPLICATION_OCTET_STREAM);
    }

    @Override
    public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
        return false;
    }

    @Override
    public boolean canRead(Type type, @Nullable Class<?> contextClass, @Nullable MediaType mediaType) {
        return false;
    }

    @Override
    public Object read(Type type, @Nullable Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ResourceRegion readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.canWrite(clazz, null, mediaType);
    }

    @Override
    public boolean canWrite(@Nullable Type type, @Nullable Class<?> clazz, @Nullable MediaType mediaType) {
        if (!(type instanceof ParameterizedType)) {
            Class c;
            return type instanceof Class && ResourceRegion.class.isAssignableFrom(c = (Class)type);
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type type2 = parameterizedType.getRawType();
        if (!(type2 instanceof Class)) {
            return false;
        }
        Class rawType = (Class)type2;
        if (!Collection.class.isAssignableFrom(rawType)) {
            return false;
        }
        if (parameterizedType.getActualTypeArguments().length != 1) {
            return false;
        }
        Type typeArgument = parameterizedType.getActualTypeArguments()[0];
        if (!(typeArgument instanceof Class)) {
            return false;
        }
        Class typeArgumentClass = (Class)typeArgument;
        return ResourceRegion.class.isAssignableFrom(typeArgumentClass);
    }

    @Override
    protected void writeInternal(Object object, @Nullable Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (object instanceof ResourceRegion) {
            ResourceRegion resourceRegion = (ResourceRegion)object;
            this.writeResourceRegion(resourceRegion, outputMessage);
        } else {
            Collection regions = (Collection)object;
            if (regions.size() == 1) {
                this.writeResourceRegion((ResourceRegion)regions.iterator().next(), outputMessage);
            } else {
                this.writeResourceRegionCollection(regions, outputMessage);
            }
        }
    }

    protected void writeResourceRegion(ResourceRegion region, HttpOutputMessage outputMessage) throws IOException {
        HttpHeaders headers = outputMessage.getHeaders();
        long start = region.getPosition();
        long end = start + region.getCount() - 1L;
        Resource resource = region.getResource();
        long resourceLength = resource.contentLength();
        end = Math.min(end, resourceLength - 1L);
        long rangeLength = end - start + 1L;
        headers.add("Content-Range", "bytes " + start + "-" + end + "/" + resourceLength);
        headers.setContentLength(rangeLength);
        if (outputMessage.supportsZeroCopy() && resource.isFile()) {
            outputMessage.sendFile(resource.getFile(), region.getPosition(), region.getCount());
        } else {
            try (InputStream in = resource.getInputStream();){
                StreamUtils.copyRange((InputStream)in, (OutputStream)outputMessage.getBody(), (long)start, (long)end);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResourceRegionCollection(Collection<ResourceRegion> resourceRegions, HttpOutputMessage outputMessage) throws IOException {
        Assert.notNull(resourceRegions, (String)"Collection of ResourceRegion should not be null");
        HttpHeaders responseHeaders = outputMessage.getHeaders();
        MediaType contentType = responseHeaders.getContentType();
        String boundaryString = MimeTypeUtils.generateMultipartBoundaryString();
        responseHeaders.setOrRemove("Content-Type", "multipart/byteranges; boundary=" + boundaryString);
        OutputStream out = outputMessage.getBody();
        Resource resource = null;
        InputStream in = null;
        long inputStreamPosition = 0L;
        try {
            for (ResourceRegion region : resourceRegions) {
                long start = region.getPosition() - inputStreamPosition;
                if (start < 0L || resource != region.getResource()) {
                    if (in != null) {
                        in.close();
                    }
                    resource = region.getResource();
                    in = resource.getInputStream();
                    inputStreamPosition = 0L;
                    start = region.getPosition();
                }
                long end = start + region.getCount() - 1L;
                ResourceRegionHttpMessageConverter.println(out);
                ResourceRegionHttpMessageConverter.print(out, "--" + boundaryString);
                ResourceRegionHttpMessageConverter.println(out);
                if (contentType != null) {
                    ResourceRegionHttpMessageConverter.print(out, "Content-Type: " + contentType);
                    ResourceRegionHttpMessageConverter.println(out);
                }
                long resourceLength = region.getResource().contentLength();
                end = Math.min(end, resourceLength - inputStreamPosition - 1L);
                ResourceRegionHttpMessageConverter.print(out, "Content-Range: bytes " + region.getPosition() + "-" + (region.getPosition() + region.getCount() - 1L) + "/" + resourceLength);
                ResourceRegionHttpMessageConverter.println(out);
                ResourceRegionHttpMessageConverter.println(out);
                StreamUtils.copyRange((InputStream)in, (OutputStream)out, (long)start, (long)end);
                inputStreamPosition += end + 1L;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        ResourceRegionHttpMessageConverter.println(out);
        ResourceRegionHttpMessageConverter.print(out, "--" + boundaryString + "--");
    }

    private static void println(OutputStream os) throws IOException {
        os.write(13);
        os.write(10);
    }

    private static void print(OutputStream os, String buf) throws IOException {
        os.write(buf.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    protected boolean supportsRepeatableWrites(Object object) {
        if (object instanceof ResourceRegion) {
            ResourceRegion resourceRegion = (ResourceRegion)object;
            return this.supportsRepeatableWrites(resourceRegion);
        }
        Collection regions = (Collection)object;
        for (ResourceRegion region : regions) {
            if (this.supportsRepeatableWrites(region)) continue;
            return false;
        }
        return true;
    }

    @Override
    private boolean supportsRepeatableWrites(ResourceRegion region) {
        return !(region.getResource() instanceof InputStreamResource);
    }
}

