/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter;

import infra.core.io.ByteArrayResource;
import infra.core.io.InputStreamResource;
import infra.core.io.Resource;
import infra.http.HttpInputMessage;
import infra.http.HttpOutputMessage;
import infra.http.MediaType;
import infra.http.MediaTypeFactory;
import infra.http.converter.AbstractHttpMessageConverter;
import infra.http.converter.HttpMessageNotReadableException;
import infra.http.converter.HttpMessageNotWritableException;
import infra.lang.Nullable;
import infra.util.StreamUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ResourceHttpMessageConverter
extends AbstractHttpMessageConverter<Resource> {
    private final boolean supportsReadStreaming;

    public ResourceHttpMessageConverter() {
        super(MediaType.ALL);
        this.supportsReadStreaming = true;
    }

    public ResourceHttpMessageConverter(boolean supportsReadStreaming) {
        super(MediaType.ALL);
        this.supportsReadStreaming = supportsReadStreaming;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return Resource.class.isAssignableFrom(clazz);
    }

    @Override
    protected Resource readInternal(Class<? extends Resource> clazz, final HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        if (this.supportsReadStreaming && InputStreamResource.class == clazz) {
            return new InputStreamResource(inputMessage.getBody()){

                public String getName() {
                    return inputMessage.getHeaders().getContentDisposition().getFilename();
                }

                public long contentLength() throws IOException {
                    long length = inputMessage.getHeaders().getContentLength();
                    return length != -1L ? length : super.contentLength();
                }
            };
        }
        if (Resource.class == clazz || ByteArrayResource.class.isAssignableFrom(clazz)) {
            byte[] body = StreamUtils.copyToByteArray((InputStream)inputMessage.getBody());
            return new ByteArrayResource(body){

                @Nullable
                public String getName() {
                    return inputMessage.getHeaders().getContentDisposition().getFilename();
                }
            };
        }
        throw new HttpMessageNotReadableException("Unsupported resource class: " + clazz, inputMessage);
    }

    @Override
    protected MediaType getDefaultContentType(Resource resource) {
        return MediaTypeFactory.getMediaType(resource).orElse(MediaType.APPLICATION_OCTET_STREAM);
    }

    @Override
    protected Long getContentLength(Resource resource, @Nullable MediaType contentType) throws IOException {
        if (InputStreamResource.class == resource.getClass()) {
            return null;
        }
        long contentLength = resource.contentLength();
        return contentLength < 0L ? null : Long.valueOf(contentLength);
    }

    @Override
    protected void writeInternal(Resource resource, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        block11: {
            try {
                if (outputMessage.supportsZeroCopy() && resource.isFile()) {
                    File file = resource.getFile();
                    outputMessage.sendFile(file);
                    break block11;
                }
                try (InputStream in = resource.getInputStream();){
                    OutputStream out = outputMessage.getBody();
                    in.transferTo(out);
                    out.flush();
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    protected boolean supportsRepeatableWrites(Resource resource) {
        return !(resource instanceof InputStreamResource);
    }
}

