/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter;

import infra.http.converter.AllEncompassingFormHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.json.GsonHttpMessageConverter;
import infra.http.converter.json.MappingJackson2HttpMessageConverter;
import infra.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import infra.util.ClassUtils;
import infra.web.config.WebMvcConfigurationSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpMessageConverters
implements Iterable<HttpMessageConverter<?>> {
    private static final Map<Class<?>, Class<?>> EQUIVALENT_CONVERTERS;
    private final List<HttpMessageConverter<?>> converters;

    public HttpMessageConverters(HttpMessageConverter<?> ... additionalConverters) {
        this(Arrays.asList(additionalConverters));
    }

    public HttpMessageConverters(Collection<HttpMessageConverter<?>> additionalConverters) {
        this(true, additionalConverters);
    }

    public HttpMessageConverters(boolean addDefaultConverters, Collection<HttpMessageConverter<?>> converters) {
        List<HttpMessageConverter<?>> combined = this.getCombinedConverters(converters, addDefaultConverters ? this.getDefaultConverters() : Collections.emptyList());
        combined = this.postProcessConverters(combined);
        this.converters = Collections.unmodifiableList(combined);
    }

    private List<HttpMessageConverter<?>> getCombinedConverters(Collection<HttpMessageConverter<?>> converters, List<HttpMessageConverter<?>> defaultConverters) {
        ArrayList combined = new ArrayList();
        ArrayList processing = new ArrayList(converters);
        for (HttpMessageConverter<?> defaultConverter : defaultConverters) {
            Iterator<HttpMessageConverter<?>> iterator = processing.iterator();
            while (iterator.hasNext()) {
                HttpMessageConverter<?> candidate = iterator.next();
                if (!this.isReplacement(defaultConverter, candidate)) continue;
                combined.add(candidate);
                iterator.remove();
            }
            combined.add(defaultConverter);
            if (!(defaultConverter instanceof AllEncompassingFormHttpMessageConverter)) continue;
            AllEncompassingFormHttpMessageConverter converter = (AllEncompassingFormHttpMessageConverter)defaultConverter;
            this.configurePartConverters(converter, converters);
        }
        combined.addAll(0, processing);
        return combined;
    }

    private boolean isReplacement(HttpMessageConverter<?> defaultConverter, HttpMessageConverter<?> candidate) {
        Class<?> converterClass = defaultConverter.getClass();
        if (ClassUtils.isAssignableValue(converterClass, candidate)) {
            return true;
        }
        Class<?> equivalentClass = EQUIVALENT_CONVERTERS.get(converterClass);
        return equivalentClass != null && ClassUtils.isAssignableValue(equivalentClass, candidate);
    }

    private void configurePartConverters(AllEncompassingFormHttpMessageConverter formConverter, Collection<HttpMessageConverter<?>> converters) {
        List<HttpMessageConverter<?>> partConverters = formConverter.getPartConverters();
        List<HttpMessageConverter<?>> combinedConverters = this.getCombinedConverters(converters, partConverters);
        combinedConverters = this.postProcessPartConverters(combinedConverters);
        formConverter.setPartConverters(combinedConverters);
    }

    protected List<HttpMessageConverter<?>> postProcessConverters(List<HttpMessageConverter<?>> converters) {
        return converters;
    }

    protected List<HttpMessageConverter<?>> postProcessPartConverters(List<HttpMessageConverter<?>> converters) {
        return converters;
    }

    private List<HttpMessageConverter<?>> getDefaultConverters() {
        ArrayList converters = new ArrayList(new WebMvcConfigurationSupport().getMessageConverters());
        this.reorderXmlConvertersToEnd(converters);
        return converters;
    }

    private void reorderXmlConvertersToEnd(ArrayList<HttpMessageConverter<?>> converters) {
        ArrayList xml = new ArrayList();
        Iterator<HttpMessageConverter<?>> iterator = converters.iterator();
        while (iterator.hasNext()) {
            HttpMessageConverter<?> converter = iterator.next();
            if (!(converter instanceof MappingJackson2XmlHttpMessageConverter)) continue;
            xml.add(converter);
            iterator.remove();
        }
        converters.addAll(xml);
    }

    @Override
    public Iterator<HttpMessageConverter<?>> iterator() {
        return this.getConverters().iterator();
    }

    public List<HttpMessageConverter<?>> getConverters() {
        return this.converters;
    }

    static {
        HashMap<Class<MappingJackson2HttpMessageConverter>, Class<GsonHttpMessageConverter>> equivalentConverters = new HashMap<Class<MappingJackson2HttpMessageConverter>, Class<GsonHttpMessageConverter>>();
        try {
            equivalentConverters.put(MappingJackson2HttpMessageConverter.class, GsonHttpMessageConverter.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EQUIVALENT_CONVERTERS = Collections.unmodifiableMap(equivalentConverters);
    }
}

