/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter;

import infra.http.HttpInputMessage;
import infra.http.HttpOutputMessage;
import infra.http.MediaType;
import infra.http.converter.HttpMessageNotReadableException;
import infra.http.converter.HttpMessageNotWritableException;
import infra.lang.Nullable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public interface HttpMessageConverter<T> {
    public boolean canRead(Class<?> var1, @Nullable MediaType var2);

    public boolean canWrite(Class<?> var1, @Nullable MediaType var2);

    public List<MediaType> getSupportedMediaTypes();

    default public List<MediaType> getSupportedMediaTypes(Class<?> clazz) {
        return this.canRead(clazz, null) || this.canWrite(clazz, null) ? this.getSupportedMediaTypes() : Collections.emptyList();
    }

    public T read(Class<? extends T> var1, HttpInputMessage var2) throws IOException, HttpMessageNotReadableException;

    public void write(T var1, @Nullable MediaType var2, HttpOutputMessage var3) throws IOException, HttpMessageNotWritableException;
}

