/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter;

import infra.core.io.Resource;
import infra.http.HttpEntity;
import infra.http.HttpHeaders;
import infra.http.HttpInputMessage;
import infra.http.HttpOutputMessage;
import infra.http.MediaType;
import infra.http.StreamingHttpOutputMessage;
import infra.http.converter.AbstractHttpMessageConverter;
import infra.http.converter.ByteArrayHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.HttpMessageNotReadableException;
import infra.http.converter.HttpMessageNotWritableException;
import infra.http.converter.ResourceHttpMessageConverter;
import infra.http.converter.StringHttpMessageConverter;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MimeTypeUtils;
import infra.util.MultiValueMap;
import infra.util.StreamUtils;
import infra.util.StringUtils;
import jakarta.mail.internet.MimeUtility;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FormHttpMessageConverter
implements HttpMessageConverter<MultiValueMap<String, ?>> {
    private ArrayList<MediaType> supportedMediaTypes = new ArrayList();
    private List<HttpMessageConverter<?>> partConverters = new ArrayList();
    private Charset charset = Constant.DEFAULT_CHARSET;
    @Nullable
    private Charset multipartCharset;

    public FormHttpMessageConverter() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_FORM_URLENCODED);
        this.supportedMediaTypes.add(MediaType.MULTIPART_FORM_DATA);
        this.supportedMediaTypes.add(MediaType.MULTIPART_MIXED);
        this.supportedMediaTypes.add(MediaType.MULTIPART_RELATED);
        this.partConverters.add(new ByteArrayHttpMessageConverter());
        this.partConverters.add(new StringHttpMessageConverter());
        this.partConverters.add(new ResourceHttpMessageConverter());
        this.applyDefaultCharset();
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        Assert.notNull(supportedMediaTypes, (String)"'supportedMediaTypes' is required");
        this.supportedMediaTypes = new ArrayList<MediaType>(supportedMediaTypes);
    }

    public void addSupportedMediaTypes(MediaType ... supportedMediaTypes) {
        Assert.notNull((Object)supportedMediaTypes, (String)"'supportedMediaTypes' is required");
        Assert.noNullElements((Object[])supportedMediaTypes, (String)"'supportedMediaTypes' must not contain null elements");
        Collections.addAll(this.supportedMediaTypes, supportedMediaTypes);
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    public void setPartConverters(List<HttpMessageConverter<?>> partConverters) {
        Assert.notEmpty(partConverters, (String)"'partConverters' must not be empty");
        this.partConverters = partConverters;
    }

    public List<HttpMessageConverter<?>> getPartConverters() {
        return this.partConverters;
    }

    public void addPartConverter(HttpMessageConverter<?> partConverter) {
        Assert.notNull(partConverter, (String)"'partConverter' is required");
        this.partConverters.add(partConverter);
    }

    public void setCharset(@Nullable Charset charset) {
        if (charset != this.charset) {
            this.charset = charset != null ? charset : Constant.DEFAULT_CHARSET;
            this.applyDefaultCharset();
        }
    }

    private void applyDefaultCharset() {
        for (HttpMessageConverter<?> candidate : this.partConverters) {
            AbstractHttpMessageConverter converter;
            if (!(candidate instanceof AbstractHttpMessageConverter) || (converter = (AbstractHttpMessageConverter)candidate).getDefaultCharset() == null) continue;
            converter.setDefaultCharset(this.charset);
        }
    }

    public void setMultipartCharset(Charset charset) {
        this.multipartCharset = charset;
    }

    @Override
    public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
        if (!MultiValueMap.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (mediaType == null) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (supportedMediaType.getType().equalsIgnoreCase("multipart") || !supportedMediaType.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        if (!MultiValueMap.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (mediaType == null || MediaType.ALL.equals(mediaType)) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MultiValueMap<String, String> read(@Nullable Class<? extends MultiValueMap<String, ?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        Charset charset = null;
        if (contentType != null) {
            charset = contentType.getCharset();
        }
        if (charset == null) {
            charset = this.charset;
        }
        String body = StreamUtils.copyToString((InputStream)inputMessage.getBody(), (Charset)charset);
        String[] pairs = StringUtils.tokenizeToStringArray((String)body, (String)"&");
        LinkedMultiValueMap result = MultiValueMap.forLinkedHashMap((int)pairs.length);
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) {
                result.add((Object)URLDecoder.decode(pair, charset), null);
                continue;
            }
            String name = URLDecoder.decode(pair.substring(0, idx), charset);
            String value = URLDecoder.decode(pair.substring(idx + 1), charset);
            result.add((Object)name, (Object)value);
        }
        return result;
    }

    @Override
    public void write(MultiValueMap<String, ?> map, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (this.isMultipart(map, contentType)) {
            this.writeMultipart(map, contentType, outputMessage);
        } else {
            this.writeForm(map, contentType, outputMessage);
        }
    }

    private boolean isMultipart(MultiValueMap<String, ?> map, @Nullable MediaType contentType) {
        if (contentType != null) {
            return contentType.getType().equalsIgnoreCase("multipart");
        }
        for (List values : map.values()) {
            for (Object value : values) {
                if (value == null || value instanceof String) continue;
                return true;
            }
        }
        return false;
    }

    private void writeForm(MultiValueMap<String, Object> formData, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException {
        contentType = this.getFormContentType(contentType);
        HttpHeaders headers = outputMessage.getHeaders();
        headers.setContentType(contentType);
        Charset charset = contentType.getCharset();
        if (charset == null) {
            charset = this.charset;
        }
        byte[] bytes = this.serializeForm(formData, charset).getBytes(charset);
        headers.setContentLength(bytes.length);
        StreamingHttpOutputMessage.writeBody(outputMessage, bytes);
    }

    protected MediaType getFormContentType(@Nullable MediaType contentType) {
        if (contentType == null) {
            return MediaType.APPLICATION_FORM_URLENCODED;
        }
        if (contentType.getCharset() == null && this.charset != Constant.DEFAULT_CHARSET) {
            return contentType.withCharset(this.charset);
        }
        return contentType;
    }

    protected String serializeForm(MultiValueMap<String, Object> formData, Charset charset) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : formData.entrySet()) {
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            if (name == null) {
                if (!CollectionUtils.isNotEmpty((Collection)values)) continue;
                throw new IllegalArgumentException("Null name in form data: " + formData);
            }
            for (Object value : values) {
                if (!builder.isEmpty()) {
                    builder.append('&');
                }
                builder.append(URLEncoder.encode(name, charset));
                if (value == null) continue;
                builder.append('=');
                builder.append(URLEncoder.encode(String.valueOf(value), charset));
            }
        }
        return builder.toString();
    }

    private void writeMultipart(MultiValueMap<String, Object> parts, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException {
        if (contentType == null) {
            contentType = MediaType.MULTIPART_FORM_DATA;
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(contentType.getParameters().size() + 2);
        parameters.putAll(contentType.getParameters());
        if (!(this.isFilenameCharsetSet() || this.charset.equals(StandardCharsets.UTF_8) || this.charset.equals(StandardCharsets.US_ASCII))) {
            parameters.put("charset", this.charset.name());
        }
        byte[] boundary = this.generateMultipartBoundary();
        parameters.put("boundary", new String(boundary, StandardCharsets.US_ASCII));
        contentType = new MediaType(contentType, parameters);
        outputMessage.getHeaders().setContentType(contentType);
        if (outputMessage instanceof StreamingHttpOutputMessage) {
            StreamingHttpOutputMessage streaming = (StreamingHttpOutputMessage)outputMessage;
            streaming.setBody(outputStream -> {
                this.writeParts(outputStream, parts, boundary);
                FormHttpMessageConverter.writeEnd(outputStream, boundary);
            });
        } else {
            this.writeParts(outputMessage.getBody(), parts, boundary);
            FormHttpMessageConverter.writeEnd(outputMessage.getBody(), boundary);
        }
    }

    private boolean isFilenameCharsetSet() {
        return this.multipartCharset != null;
    }

    private void writeParts(OutputStream os, MultiValueMap<String, Object> parts, byte[] boundary) throws IOException {
        for (Map.Entry entry : parts.entrySet()) {
            String name = (String)entry.getKey();
            for (Object part : (List)entry.getValue()) {
                if (part == null) continue;
                this.writeBoundary(os, boundary);
                this.writePart(name, this.getHttpEntity(part), os);
                FormHttpMessageConverter.writeNewLine(os);
            }
        }
    }

    private void writePart(String name, HttpEntity<?> partEntity, OutputStream os) throws IOException {
        Object partBody = partEntity.getBody();
        if (partBody == null) {
            throw new IllegalStateException("Empty body for part '%s': %s".formatted(name, partEntity));
        }
        Class<?> partType = partBody.getClass();
        HttpHeaders partHeaders = partEntity.getHeaders();
        MediaType partContentType = partHeaders.getContentType();
        for (HttpMessageConverter<?> messageConverter : this.partConverters) {
            if (!messageConverter.canWrite(partType, partContentType)) continue;
            Charset charset = this.isFilenameCharsetSet() ? StandardCharsets.US_ASCII : this.charset;
            MultipartHttpOutputMessage multipartMessage = new MultipartHttpOutputMessage(os, charset);
            multipartMessage.getHeaders().setContentDispositionFormData(name, this.getFilename(partBody));
            if (!partHeaders.isEmpty()) {
                multipartMessage.getHeaders().putAll((Map)((Object)partHeaders));
            }
            messageConverter.write(partBody, partContentType, multipartMessage);
            return;
        }
        throw new HttpMessageNotWritableException("Could not write request: no suitable HttpMessageConverter found for request type [%s]".formatted(partType.getName()));
    }

    protected byte[] generateMultipartBoundary() {
        return MimeTypeUtils.generateMultipartBoundary();
    }

    protected HttpEntity<?> getHttpEntity(Object part) {
        HttpEntity<Object> httpEntity;
        if (part instanceof HttpEntity) {
            HttpEntity httpEntity2 = (HttpEntity)part;
            httpEntity = httpEntity2;
        } else {
            httpEntity = new HttpEntity<Object>(part);
        }
        return httpEntity;
    }

    @Nullable
    protected String getFilename(Object part) {
        if (part instanceof Resource) {
            Resource resource = (Resource)part;
            String filename = resource.getName();
            if (filename != null && this.multipartCharset != null) {
                filename = MimeDelegate.encode(filename, this.multipartCharset.name());
            }
            return filename;
        }
        return null;
    }

    private void writeBoundary(OutputStream os, byte[] boundary) throws IOException {
        os.write(45);
        os.write(45);
        os.write(boundary);
        FormHttpMessageConverter.writeNewLine(os);
    }

    private static void writeEnd(OutputStream os, byte[] boundary) throws IOException {
        os.write(45);
        os.write(45);
        os.write(boundary);
        os.write(45);
        os.write(45);
        FormHttpMessageConverter.writeNewLine(os);
    }

    private static void writeNewLine(OutputStream os) throws IOException {
        os.write(13);
        os.write(10);
    }

    private static class MultipartHttpOutputMessage
    implements HttpOutputMessage {
        private final Charset charset;
        private final OutputStream outputStream;
        private final HttpHeaders headers = HttpHeaders.forWritable();
        private boolean headersWritten = false;

        public MultipartHttpOutputMessage(OutputStream outputStream, Charset charset) {
            this.outputStream = new MultipartOutputStream(outputStream);
            this.charset = charset;
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.headersWritten ? this.headers.asReadOnly() : this.headers;
        }

        @Override
        public OutputStream getBody() throws IOException {
            this.writeHeaders();
            return this.outputStream;
        }

        private void writeHeaders() throws IOException {
            if (!this.headersWritten) {
                for (Map.Entry entry : this.headers.entrySet()) {
                    byte[] headerName = this.getBytes((String)entry.getKey());
                    for (String headerValueString : (List)entry.getValue()) {
                        byte[] headerValue = this.getBytes(headerValueString);
                        this.outputStream.write(headerName);
                        this.outputStream.write(58);
                        this.outputStream.write(32);
                        this.outputStream.write(headerValue);
                        FormHttpMessageConverter.writeNewLine(this.outputStream);
                    }
                }
                FormHttpMessageConverter.writeNewLine(this.outputStream);
                this.headersWritten = true;
            }
        }

        private byte[] getBytes(String name) {
            return name.getBytes(this.charset);
        }
    }

    private static class MimeDelegate {
        private MimeDelegate() {
        }

        public static String encode(String value, String charset) {
            try {
                return MimeUtility.encodeText((String)value, (String)charset, null);
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static class MultipartOutputStream
    extends FilterOutputStream {
        public MultipartOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int let) throws IOException {
            this.out.write(b, off, let);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

