/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter;

import infra.http.HttpInputMessage;
import infra.http.HttpOutputMessage;
import infra.http.MediaType;
import infra.http.converter.AbstractHttpMessageConverter;
import infra.lang.Nullable;
import infra.util.StreamUtils;
import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayHttpMessageConverter
extends AbstractHttpMessageConverter<byte[]> {
    public ByteArrayHttpMessageConverter() {
        super(MediaType.APPLICATION_OCTET_STREAM, MediaType.ALL);
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return byte[].class == clazz;
    }

    @Override
    public byte[] readInternal(Class<? extends byte[]> clazz, HttpInputMessage message) throws IOException {
        long length = message.getHeaders().getContentLength();
        return length >= 0L && length < Integer.MAX_VALUE ? message.getBody().readNBytes((int)length) : message.getBody().readAllBytes();
    }

    @Override
    protected Long getContentLength(byte[] bytes, @Nullable MediaType contentType) {
        return bytes.length;
    }

    @Override
    protected void writeInternal(byte[] bytes, HttpOutputMessage outputMessage) throws IOException {
        StreamUtils.copy((byte[])bytes, (OutputStream)outputMessage.getBody());
    }

    @Override
    protected boolean supportsRepeatableWrites(byte[] bytes) {
        return true;
    }
}

