/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter;

import infra.http.converter.FormHttpMessageConverter;
import infra.http.converter.json.GsonHttpMessageConverter;
import infra.http.converter.json.JsonbHttpMessageConverter;
import infra.http.converter.json.MappingJackson2HttpMessageConverter;
import infra.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import infra.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import infra.http.converter.yaml.MappingJackson2YamlHttpMessageConverter;
import infra.util.ClassUtils;

public class AllEncompassingFormHttpMessageConverter
extends FormHttpMessageConverter {
    private static final boolean jackson2Present;
    private static final boolean jackson2SmilePresent;
    private static final boolean gsonPresent;
    private static final boolean jsonbPresent;
    private static final boolean jackson2XmlPresent;
    private static final boolean jackson2YamlPresent;

    public AllEncompassingFormHttpMessageConverter() {
        if (jackson2Present) {
            this.addPartConverter(new MappingJackson2HttpMessageConverter());
        } else if (gsonPresent) {
            this.addPartConverter(new GsonHttpMessageConverter());
        } else if (jsonbPresent) {
            this.addPartConverter(new JsonbHttpMessageConverter());
        }
        if (jackson2XmlPresent) {
            this.addPartConverter(new MappingJackson2XmlHttpMessageConverter());
        }
        if (jackson2SmilePresent) {
            this.addPartConverter(new MappingJackson2SmileHttpMessageConverter());
        }
        if (jackson2YamlPresent) {
            this.addPartConverter(new MappingJackson2YamlHttpMessageConverter());
        }
    }

    static {
        ClassLoader classLoader = AllEncompassingFormHttpMessageConverter.class.getClassLoader();
        jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)classLoader);
        jackson2SmilePresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.smile.SmileFactory", (ClassLoader)classLoader);
        gsonPresent = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)classLoader);
        jsonbPresent = ClassUtils.isPresent((String)"jakarta.json.bind.Jsonb", (ClassLoader)classLoader);
        jackson2XmlPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.xml.XmlMapper", (ClassLoader)classLoader);
        jackson2YamlPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.yaml.YAMLFactory", (ClassLoader)classLoader);
    }
}

