/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter;

import infra.http.HttpHeaders;
import infra.http.HttpInputMessage;
import infra.http.HttpLogging;
import infra.http.HttpOutputMessage;
import infra.http.MediaType;
import infra.http.StreamingHttpOutputMessage;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.HttpMessageNotReadableException;
import infra.http.converter.HttpMessageNotWritableException;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class AbstractHttpMessageConverter<T>
implements HttpMessageConverter<T> {
    protected final Logger logger = HttpLogging.forLogName(this.getClass());
    private List<MediaType> supportedMediaTypes = Collections.emptyList();
    @Nullable
    private Charset defaultCharset;

    protected AbstractHttpMessageConverter() {
    }

    protected AbstractHttpMessageConverter(MediaType ... supportedMediaTypes) {
        this.setSupportedMediaTypes(Arrays.asList(supportedMediaTypes));
    }

    protected AbstractHttpMessageConverter(@Nullable Charset defaultCharset, MediaType ... supportedMediaTypes) {
        this.defaultCharset = defaultCharset;
        this.setSupportedMediaTypes(Arrays.asList(supportedMediaTypes));
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        Assert.notEmpty(supportedMediaTypes, (String)"MediaType List must not be empty");
        this.supportedMediaTypes = List.copyOf(supportedMediaTypes);
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    public void setDefaultCharset(@Nullable Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    @Nullable
    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    @Override
    public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.supports(clazz) && this.canRead(mediaType);
    }

    protected boolean canRead(@Nullable MediaType mediaType) {
        if (mediaType == null) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (!supportedMediaType.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.supports(clazz) && this.canWrite(mediaType);
    }

    protected boolean canWrite(@Nullable MediaType mediaType) {
        if (mediaType == null || MediaType.ALL.equalsTypeAndSubtype(mediaType)) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final T read(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.readInternal(clazz, inputMessage);
    }

    @Override
    public final void write(final T t, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        final HttpHeaders headers = outputMessage.getHeaders();
        this.addDefaultHeaders(headers, t, contentType);
        if (outputMessage instanceof StreamingHttpOutputMessage) {
            StreamingHttpOutputMessage streaming = (StreamingHttpOutputMessage)outputMessage;
            streaming.setBody(new StreamingHttpOutputMessage.Body(){

                @Override
                public void writeTo(final OutputStream outputStream) throws IOException {
                    AbstractHttpMessageConverter.this.writeInternal(t, new HttpOutputMessage(){

                        @Override
                        public OutputStream getBody() {
                            return outputStream;
                        }

                        @Override
                        public HttpHeaders getHeaders() {
                            return headers;
                        }
                    });
                }

                @Override
                public boolean repeatable() {
                    return AbstractHttpMessageConverter.this.supportsRepeatableWrites(t);
                }
            });
        } else {
            this.writeInternal(t, outputMessage);
        }
    }

    public void addDefaultHeaders(HttpHeaders headers, T t, @Nullable MediaType contentType) throws IOException {
        Long contentLength;
        String contentTypeString = headers.getFirst("Content-Type");
        if (contentTypeString == null) {
            MediaType mediaType;
            MediaType contentTypeToUse = contentType;
            if (contentType == null || !contentType.isConcrete()) {
                contentTypeToUse = this.getDefaultContentType(t);
            } else if (MediaType.APPLICATION_OCTET_STREAM.equals(contentType) && (mediaType = this.getDefaultContentType(t)) != null) {
                contentTypeToUse = mediaType;
            }
            if (contentTypeToUse != null) {
                Charset defaultCharset;
                if (contentTypeToUse.getCharset() == null && (defaultCharset = this.getDefaultCharset()) != null) {
                    contentTypeToUse = contentTypeToUse.withCharset(defaultCharset);
                }
                headers.setContentType(contentTypeToUse);
            }
        }
        if (!"text/event-stream".equals(contentTypeString) && !headers.containsKey("Transfer-Encoding") && headers.getContentLength() < 0L && (contentLength = this.getContentLength(t, headers.getContentType())) != null) {
            headers.setContentLength(contentLength);
        }
    }

    @Nullable
    protected MediaType getDefaultContentType(T t) throws IOException {
        List<MediaType> mediaTypes = this.getSupportedMediaTypes();
        return !mediaTypes.isEmpty() ? mediaTypes.get(0) : null;
    }

    @Nullable
    protected Long getContentLength(T t, @Nullable MediaType contentType) throws IOException {
        return null;
    }

    protected boolean supportsRepeatableWrites(T t) {
        return false;
    }

    protected abstract boolean supports(Class<?> var1);

    protected abstract T readInternal(Class<? extends T> var1, HttpInputMessage var2) throws IOException, HttpMessageNotReadableException;

    protected abstract void writeInternal(T var1, HttpOutputMessage var2) throws IOException, HttpMessageNotWritableException;
}

