/*
 * Decompiled with CFR 0.152.
 */
package infra.http.converter;

import infra.http.HttpHeaders;
import infra.http.HttpOutputMessage;
import infra.http.MediaType;
import infra.http.StreamingHttpOutputMessage;
import infra.http.converter.AbstractHttpMessageConverter;
import infra.http.converter.GenericHttpMessageConverter;
import infra.http.converter.HttpMessageNotWritableException;
import infra.lang.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;

public abstract class AbstractGenericHttpMessageConverter<T>
extends AbstractHttpMessageConverter<T>
implements GenericHttpMessageConverter<T> {
    protected AbstractGenericHttpMessageConverter() {
    }

    protected AbstractGenericHttpMessageConverter(MediaType ... supportedMediaTypes) {
        this((Charset)null, supportedMediaTypes);
    }

    protected AbstractGenericHttpMessageConverter(@Nullable Charset defaultCharset, MediaType ... supportedMediaTypes) {
        super(defaultCharset, supportedMediaTypes);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    public boolean canRead(Type type, @Nullable Class<?> contextClass, @Nullable MediaType mediaType) {
        boolean bl;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            bl = this.canRead(clazz, mediaType);
        } else {
            bl = this.canRead(mediaType);
        }
        return bl;
    }

    @Override
    public boolean canWrite(@Nullable Type type, Class<?> clazz, @Nullable MediaType mediaType) {
        return this.canWrite(clazz, mediaType);
    }

    @Override
    public final void write(final T t, final @Nullable Type type, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        final HttpHeaders headers = outputMessage.getHeaders();
        this.addDefaultHeaders(headers, t, contentType);
        if (outputMessage instanceof StreamingHttpOutputMessage) {
            StreamingHttpOutputMessage streaming = (StreamingHttpOutputMessage)outputMessage;
            streaming.setBody(new StreamingHttpOutputMessage.Body(){

                @Override
                public void writeTo(final OutputStream outputStream) throws IOException {
                    AbstractGenericHttpMessageConverter.this.writeInternal(t, type, new HttpOutputMessage(){

                        @Override
                        public OutputStream getBody() {
                            return outputStream;
                        }

                        @Override
                        public HttpHeaders getHeaders() {
                            return headers;
                        }
                    });
                }

                @Override
                public boolean repeatable() {
                    return AbstractGenericHttpMessageConverter.this.supportsRepeatableWrites(t);
                }
            });
        } else {
            this.writeInternal(t, type, outputMessage);
        }
    }

    @Override
    protected void writeInternal(T t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.writeInternal(t, null, outputMessage);
    }

    protected abstract void writeInternal(T var1, @Nullable Type var2, HttpOutputMessage var3) throws IOException, HttpMessageNotWritableException;
}

