/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec.support;

import com.google.protobuf.Message;
import infra.core.codec.AbstractDataBufferDecoder;
import infra.core.codec.ByteArrayDecoder;
import infra.core.codec.ByteArrayEncoder;
import infra.core.codec.ByteBufferDecoder;
import infra.core.codec.ByteBufferEncoder;
import infra.core.codec.CharSequenceEncoder;
import infra.core.codec.DataBufferDecoder;
import infra.core.codec.DataBufferEncoder;
import infra.core.codec.Decoder;
import infra.core.codec.Encoder;
import infra.core.codec.Netty5BufferDecoder;
import infra.core.codec.Netty5BufferEncoder;
import infra.core.codec.NettyByteBufDecoder;
import infra.core.codec.NettyByteBufEncoder;
import infra.core.codec.ResourceDecoder;
import infra.core.codec.StringDecoder;
import infra.http.codec.CodecConfigurer;
import infra.http.codec.DecoderHttpMessageReader;
import infra.http.codec.EncoderHttpMessageWriter;
import infra.http.codec.FormHttpMessageReader;
import infra.http.codec.FormHttpMessageWriter;
import infra.http.codec.HttpMessageReader;
import infra.http.codec.HttpMessageWriter;
import infra.http.codec.ResourceHttpMessageReader;
import infra.http.codec.ResourceHttpMessageWriter;
import infra.http.codec.ServerSentEventHttpMessageReader;
import infra.http.codec.ServerSentEventHttpMessageWriter;
import infra.http.codec.json.AbstractJackson2Decoder;
import infra.http.codec.json.Jackson2JsonDecoder;
import infra.http.codec.json.Jackson2JsonEncoder;
import infra.http.codec.json.Jackson2SmileDecoder;
import infra.http.codec.json.Jackson2SmileEncoder;
import infra.http.codec.multipart.DefaultPartHttpMessageReader;
import infra.http.codec.multipart.MultipartHttpMessageReader;
import infra.http.codec.multipart.MultipartHttpMessageWriter;
import infra.http.codec.multipart.PartEventHttpMessageReader;
import infra.http.codec.multipart.PartEventHttpMessageWriter;
import infra.http.codec.multipart.PartHttpMessageWriter;
import infra.http.codec.protobuf.ProtobufDecoder;
import infra.http.codec.protobuf.ProtobufEncoder;
import infra.http.codec.protobuf.ProtobufHttpMessageWriter;
import infra.http.codec.support.BaseCodecConfigurer;
import infra.lang.Nullable;
import infra.util.ClassUtils;
import infra.util.MultiValueMap;
import infra.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

class BaseDefaultCodecs
implements CodecConfigurer.DefaultCodecs,
CodecConfigurer.DefaultCodecConfig {
    static final boolean jackson2Present;
    static final boolean nettyByteBufPresent;
    private static final boolean protobufPresent;
    private static final boolean jackson2SmilePresent;
    static final boolean netty5BufferPresent;
    @Nullable
    private Decoder<?> jackson2JsonDecoder;
    @Nullable
    private Encoder<?> jackson2JsonEncoder;
    @Nullable
    private Encoder<?> jackson2SmileEncoder;
    @Nullable
    private Decoder<?> jackson2SmileDecoder;
    @Nullable
    private Decoder<?> protobufDecoder;
    @Nullable
    private Encoder<?> protobufEncoder;
    @Nullable
    private DefaultMultipartCodecs multipartCodecs;
    @Nullable
    private Supplier<List<HttpMessageWriter<?>>> partWritersSupplier;
    @Nullable
    private HttpMessageReader<?> multipartReader;
    @Nullable
    private Consumer<Object> codecConsumer;
    @Nullable
    private Integer maxInMemorySize;
    @Nullable
    private Boolean enableLoggingRequestDetails;
    private boolean registerDefaults = true;
    private final ArrayList<HttpMessageReader<?>> typedReaders = new ArrayList();
    private final ArrayList<HttpMessageReader<?>> objectReaders = new ArrayList();
    private final ArrayList<HttpMessageWriter<?>> typedWriters = new ArrayList();
    private final ArrayList<HttpMessageWriter<?>> objectWriters = new ArrayList();

    BaseDefaultCodecs() {
        this.initReaders();
        this.initWriters();
    }

    protected void initReaders() {
        this.initTypedReaders();
        this.initObjectReaders();
    }

    protected void initWriters() {
        this.initTypedWriters();
        this.initObjectWriters();
    }

    protected BaseDefaultCodecs(BaseDefaultCodecs other) {
        this.jackson2JsonDecoder = other.jackson2JsonDecoder;
        this.jackson2JsonEncoder = other.jackson2JsonEncoder;
        this.jackson2SmileDecoder = other.jackson2SmileDecoder;
        this.jackson2SmileEncoder = other.jackson2SmileEncoder;
        this.protobufDecoder = other.protobufDecoder;
        this.protobufEncoder = other.protobufEncoder;
        this.multipartCodecs = other.multipartCodecs != null ? new DefaultMultipartCodecs(other.multipartCodecs) : null;
        this.multipartReader = other.multipartReader;
        this.codecConsumer = other.codecConsumer;
        this.maxInMemorySize = other.maxInMemorySize;
        this.enableLoggingRequestDetails = other.enableLoggingRequestDetails;
        this.registerDefaults = other.registerDefaults;
        this.typedReaders.addAll(other.typedReaders);
        this.objectReaders.addAll(other.objectReaders);
        this.typedWriters.addAll(other.typedWriters);
        this.objectWriters.addAll(other.objectWriters);
    }

    @Override
    public void jackson2JsonDecoder(Decoder<?> decoder) {
        this.jackson2JsonDecoder = decoder;
        this.initObjectReaders();
    }

    @Override
    public void jackson2JsonEncoder(Encoder<?> encoder) {
        this.jackson2JsonEncoder = encoder;
        this.initObjectWriters();
        this.initTypedWriters();
    }

    @Override
    public void jackson2SmileDecoder(Decoder<?> decoder) {
        this.jackson2SmileDecoder = decoder;
        this.initObjectReaders();
    }

    @Override
    public void jackson2SmileEncoder(Encoder<?> encoder) {
        this.jackson2SmileEncoder = encoder;
        this.initObjectWriters();
        this.initTypedWriters();
    }

    @Override
    public void protobufDecoder(Decoder<?> decoder) {
        this.protobufDecoder = decoder;
        this.initTypedReaders();
    }

    @Override
    public void protobufEncoder(Encoder<?> encoder) {
        this.protobufEncoder = encoder;
        this.initTypedWriters();
    }

    @Override
    public void configureDefaultCodec(Consumer<Object> codecConsumer) {
        this.codecConsumer = this.codecConsumer != null ? this.codecConsumer.andThen(codecConsumer) : codecConsumer;
        this.initReaders();
        this.initWriters();
    }

    @Override
    public void maxInMemorySize(int byteCount) {
        if (!ObjectUtils.nullSafeEquals((Object)this.maxInMemorySize, (Object)byteCount)) {
            this.maxInMemorySize = byteCount;
            this.initReaders();
        }
    }

    @Override
    @Nullable
    public Integer maxInMemorySize() {
        return this.maxInMemorySize;
    }

    @Override
    public void enableLoggingRequestDetails(boolean enable) {
        if (!ObjectUtils.nullSafeEquals((Object)this.enableLoggingRequestDetails, (Object)enable)) {
            this.enableLoggingRequestDetails = enable;
            this.initReaders();
            this.initWriters();
        }
    }

    @Override
    public CodecConfigurer.MultipartCodecs multipartCodecs() {
        if (this.multipartCodecs == null) {
            this.multipartCodecs = new DefaultMultipartCodecs();
        }
        return this.multipartCodecs;
    }

    @Override
    public void multipartReader(HttpMessageReader<?> multipartReader) {
        this.multipartReader = multipartReader;
        this.initTypedReaders();
    }

    void setPartWritersSupplier(Supplier<List<HttpMessageWriter<?>>> supplier) {
        this.partWritersSupplier = supplier;
        this.initTypedWriters();
    }

    @Override
    @Nullable
    public Boolean isEnableLoggingRequestDetails() {
        return this.enableLoggingRequestDetails;
    }

    void registerDefaults(boolean registerDefaults) {
        if (this.registerDefaults != registerDefaults) {
            this.registerDefaults = registerDefaults;
            this.initReaders();
            this.initWriters();
        }
    }

    final List<HttpMessageReader<?>> getTypedReaders() {
        return this.typedReaders;
    }

    protected void initTypedReaders() {
        this.typedReaders.clear();
        if (!this.registerDefaults) {
            return;
        }
        this.addCodec(this.typedReaders, new DecoderHttpMessageReader(new ByteArrayDecoder()));
        this.addCodec(this.typedReaders, new DecoderHttpMessageReader(new ByteBufferDecoder()));
        this.addCodec(this.typedReaders, new DecoderHttpMessageReader(new DataBufferDecoder()));
        if (nettyByteBufPresent) {
            this.addCodec(this.typedReaders, new DecoderHttpMessageReader(new NettyByteBufDecoder()));
        }
        if (netty5BufferPresent) {
            this.addCodec(this.typedReaders, new DecoderHttpMessageReader(new Netty5BufferDecoder()));
        }
        this.addCodec(this.typedReaders, new ResourceHttpMessageReader(new ResourceDecoder()));
        this.addCodec(this.typedReaders, new DecoderHttpMessageReader(StringDecoder.textPlainOnly()));
        if (protobufPresent) {
            this.addCodec(this.typedReaders, new DecoderHttpMessageReader<Message>(this.protobufDecoder != null ? (ProtobufDecoder)this.protobufDecoder : new ProtobufDecoder()));
        }
        this.addCodec(this.typedReaders, new FormHttpMessageReader());
        if (this.multipartReader != null) {
            this.addCodec(this.typedReaders, this.multipartReader);
        } else {
            DefaultPartHttpMessageReader partReader = new DefaultPartHttpMessageReader();
            this.addCodec(this.typedReaders, partReader);
            this.addCodec(this.typedReaders, new MultipartHttpMessageReader(partReader));
        }
        this.addCodec(this.typedReaders, new PartEventHttpMessageReader());
        this.extendTypedReaders(this.typedReaders);
    }

    protected <T> void addCodec(List<T> codecs, T codec) {
        this.initCodec(codec);
        codecs.add(codec);
    }

    private void initCodec(@Nullable Object codec) {
        Boolean enable;
        if (codec instanceof DecoderHttpMessageReader) {
            codec = ((DecoderHttpMessageReader)codec).getDecoder();
        } else if (codec instanceof EncoderHttpMessageWriter) {
            codec = ((EncoderHttpMessageWriter)codec).getEncoder();
        }
        if (codec == null) {
            return;
        }
        Integer size = this.maxInMemorySize;
        if (size != null) {
            if (codec instanceof AbstractDataBufferDecoder) {
                ((AbstractDataBufferDecoder)codec).setMaxInMemorySize(size.intValue());
            }
            if (protobufPresent && codec instanceof ProtobufDecoder) {
                ((ProtobufDecoder)codec).setMaxMessageSize(size);
            }
            if (jackson2Present && codec instanceof AbstractJackson2Decoder) {
                ((AbstractJackson2Decoder)codec).setMaxInMemorySize(size);
            }
            if (codec instanceof FormHttpMessageReader) {
                ((FormHttpMessageReader)codec).setMaxInMemorySize(size);
            }
            if (codec instanceof ServerSentEventHttpMessageReader) {
                ((ServerSentEventHttpMessageReader)codec).setMaxInMemorySize(size);
            }
            if (codec instanceof DefaultPartHttpMessageReader) {
                ((DefaultPartHttpMessageReader)codec).setMaxInMemorySize(size);
            }
            if (codec instanceof PartEventHttpMessageReader) {
                ((PartEventHttpMessageReader)codec).setMaxInMemorySize(size);
            }
        }
        if ((enable = this.enableLoggingRequestDetails) != null) {
            if (codec instanceof FormHttpMessageReader) {
                ((FormHttpMessageReader)codec).setEnableLoggingRequestDetails(enable);
            }
            if (codec instanceof MultipartHttpMessageReader) {
                ((MultipartHttpMessageReader)codec).setEnableLoggingRequestDetails(enable);
            }
            if (codec instanceof DefaultPartHttpMessageReader) {
                ((DefaultPartHttpMessageReader)codec).setEnableLoggingRequestDetails(enable);
            }
            if (codec instanceof PartEventHttpMessageReader) {
                ((PartEventHttpMessageReader)codec).setEnableLoggingRequestDetails(enable);
            }
            if (codec instanceof FormHttpMessageWriter) {
                ((FormHttpMessageWriter)codec).setEnableLoggingRequestDetails(enable);
            }
            if (codec instanceof MultipartHttpMessageWriter) {
                ((MultipartHttpMessageWriter)codec).setEnableLoggingRequestDetails(enable);
            }
        }
        if (this.codecConsumer != null) {
            this.codecConsumer.accept(codec);
        }
        if (codec instanceof MultipartHttpMessageReader) {
            this.initCodec(((MultipartHttpMessageReader)codec).getPartReader());
        } else if (codec instanceof MultipartHttpMessageWriter) {
            this.initCodec(((MultipartHttpMessageWriter)codec).getFormWriter());
        } else if (codec instanceof ServerSentEventHttpMessageReader) {
            this.initCodec(((ServerSentEventHttpMessageReader)codec).getDecoder());
        } else if (codec instanceof ServerSentEventHttpMessageWriter) {
            this.initCodec(((ServerSentEventHttpMessageWriter)codec).getEncoder());
        }
    }

    protected void extendTypedReaders(List<HttpMessageReader<?>> typedReaders) {
    }

    final List<HttpMessageReader<?>> getObjectReaders() {
        return this.objectReaders;
    }

    protected void initObjectReaders() {
        this.objectReaders.clear();
        if (!this.registerDefaults) {
            return;
        }
        if (jackson2Present) {
            this.addCodec(this.objectReaders, new DecoderHttpMessageReader(this.getJackson2JsonDecoder()));
        }
        if (jackson2SmilePresent) {
            this.addCodec(this.objectReaders, new DecoderHttpMessageReader<Object>(this.jackson2SmileDecoder != null ? (Jackson2SmileDecoder)this.jackson2SmileDecoder : new Jackson2SmileDecoder()));
        }
        this.extendObjectReaders(this.objectReaders);
    }

    protected void extendObjectReaders(List<HttpMessageReader<?>> objectReaders) {
    }

    final List<HttpMessageReader<?>> getCatchAllReaders() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList readers = new ArrayList();
        this.addCodec(readers, new DecoderHttpMessageReader(StringDecoder.allMimeTypes()));
        return readers;
    }

    final List<HttpMessageWriter<?>> getTypedWriters() {
        return this.typedWriters;
    }

    protected void initTypedWriters() {
        this.typedWriters.clear();
        if (!this.registerDefaults) {
            return;
        }
        this.typedWriters.addAll(this.getBaseTypedWriters());
        this.extendTypedWriters(this.typedWriters);
    }

    final List<HttpMessageWriter<?>> getBaseTypedWriters() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList writers = new ArrayList();
        this.addCodec(writers, new EncoderHttpMessageWriter(new ByteArrayEncoder()));
        this.addCodec(writers, new EncoderHttpMessageWriter(new ByteBufferEncoder()));
        this.addCodec(writers, new EncoderHttpMessageWriter(new DataBufferEncoder()));
        if (nettyByteBufPresent) {
            this.addCodec(writers, new EncoderHttpMessageWriter(new NettyByteBufEncoder()));
        }
        if (netty5BufferPresent) {
            this.addCodec(writers, new EncoderHttpMessageWriter(new Netty5BufferEncoder()));
        }
        this.addCodec(writers, new ResourceHttpMessageWriter());
        this.addCodec(writers, new EncoderHttpMessageWriter(CharSequenceEncoder.textPlainOnly()));
        if (protobufPresent) {
            this.addCodec(writers, new ProtobufHttpMessageWriter(this.protobufEncoder != null ? (ProtobufEncoder)this.protobufEncoder : new ProtobufEncoder()));
        }
        this.addCodec(writers, new MultipartHttpMessageWriter(this::getPartWriters, (HttpMessageWriter<MultiValueMap<String, String>>)new FormHttpMessageWriter()));
        this.addCodec(writers, new PartEventHttpMessageWriter());
        this.addCodec(writers, new PartHttpMessageWriter());
        return writers;
    }

    private List<HttpMessageWriter<?>> getPartWriters() {
        if (this.multipartCodecs != null) {
            return this.multipartCodecs.getWriters();
        }
        if (this.partWritersSupplier != null) {
            return this.partWritersSupplier.get();
        }
        return Collections.emptyList();
    }

    protected void extendTypedWriters(List<HttpMessageWriter<?>> typedWriters) {
    }

    final List<HttpMessageWriter<?>> getObjectWriters() {
        return this.objectWriters;
    }

    protected void initObjectWriters() {
        this.objectWriters.clear();
        if (!this.registerDefaults) {
            return;
        }
        this.objectWriters.addAll(this.getBaseObjectWriters());
        this.extendObjectWriters(this.objectWriters);
    }

    final List<HttpMessageWriter<?>> getBaseObjectWriters() {
        ArrayList writers = new ArrayList();
        if (jackson2Present) {
            this.addCodec(writers, new EncoderHttpMessageWriter(this.getJackson2JsonEncoder()));
        }
        if (jackson2SmilePresent) {
            this.addCodec(writers, new EncoderHttpMessageWriter<Object>(this.jackson2SmileEncoder != null ? (Jackson2SmileEncoder)this.jackson2SmileEncoder : new Jackson2SmileEncoder()));
        }
        return writers;
    }

    protected void extendObjectWriters(List<HttpMessageWriter<?>> objectWriters) {
    }

    List<HttpMessageWriter<?>> getCatchAllWriters() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        result.add(new EncoderHttpMessageWriter(CharSequenceEncoder.allMimeTypes()));
        return result;
    }

    void applyDefaultConfig(BaseCodecConfigurer.DefaultCustomCodecs customCodecs) {
        this.applyDefaultConfig(customCodecs.getTypedReaders());
        this.applyDefaultConfig(customCodecs.getObjectReaders());
        this.applyDefaultConfig(customCodecs.getTypedWriters());
        this.applyDefaultConfig(customCodecs.getObjectWriters());
        customCodecs.getDefaultConfigConsumers().forEach(consumer -> consumer.accept(this));
    }

    private void applyDefaultConfig(Map<?, Boolean> readers) {
        readers.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).forEach(this::initCodec);
    }

    protected Decoder<?> getJackson2JsonDecoder() {
        if (this.jackson2JsonDecoder == null) {
            this.jackson2JsonDecoder = new Jackson2JsonDecoder();
        }
        return this.jackson2JsonDecoder;
    }

    protected Encoder<?> getJackson2JsonEncoder() {
        if (this.jackson2JsonEncoder == null) {
            this.jackson2JsonEncoder = new Jackson2JsonEncoder();
        }
        return this.jackson2JsonEncoder;
    }

    static {
        ClassLoader classLoader = BaseCodecConfigurer.class.getClassLoader();
        jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)classLoader);
        jackson2SmilePresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.smile.SmileFactory", (ClassLoader)classLoader);
        protobufPresent = ClassUtils.isPresent((String)"com.google.protobuf.Message", (ClassLoader)classLoader);
        nettyByteBufPresent = ClassUtils.isPresent((String)"io.netty.buffer.ByteBuf", (ClassLoader)classLoader);
        netty5BufferPresent = ClassUtils.isPresent((String)"io.netty5.buffer.Buffer", (ClassLoader)classLoader);
    }

    protected class DefaultMultipartCodecs
    implements CodecConfigurer.MultipartCodecs {
        private final List<HttpMessageWriter<?>> writers = new ArrayList();

        DefaultMultipartCodecs() {
        }

        DefaultMultipartCodecs(DefaultMultipartCodecs other) {
            this.writers.addAll(other.writers);
        }

        @Override
        public CodecConfigurer.MultipartCodecs encoder(Encoder<?> encoder) {
            this.writer(new EncoderHttpMessageWriter(encoder));
            BaseDefaultCodecs.this.initTypedWriters();
            return this;
        }

        @Override
        public CodecConfigurer.MultipartCodecs writer(HttpMessageWriter<?> writer) {
            this.writers.add(writer);
            BaseDefaultCodecs.this.initTypedWriters();
            return this;
        }

        List<HttpMessageWriter<?>> getWriters() {
            return this.writers;
        }
    }
}

