/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec.protobuf;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import infra.core.ResolvableType;
import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.http.MediaType;
import infra.http.codec.HttpMessageEncoder;
import infra.lang.Nullable;
import infra.util.FastByteArrayOutputStream;
import infra.util.MimeType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ProtobufJsonEncoder
implements HttpMessageEncoder<Message> {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final ResolvableType MESSAGE_TYPE = ResolvableType.forClass(Message.class);
    private static final List<MimeType> defaultMimeTypes = List.of(MediaType.APPLICATION_JSON, new MediaType("application", "*+json"));
    private final JsonFormat.Printer printer;

    public ProtobufJsonEncoder() {
        this(JsonFormat.printer());
    }

    public ProtobufJsonEncoder(JsonFormat.Printer printer) {
        this.printer = printer;
    }

    @Override
    public List<MediaType> getStreamingMediaTypes() {
        return List.of(MediaType.APPLICATION_NDJSON);
    }

    public List<MimeType> getEncodableMimeTypes() {
        return defaultMimeTypes;
    }

    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return Message.class.isAssignableFrom(elementType.toClass()) && ProtobufJsonEncoder.supportsMimeType(mimeType);
    }

    private static boolean supportsMimeType(@Nullable MimeType mimeType) {
        if (mimeType == null) {
            return false;
        }
        for (MimeType m : defaultMimeTypes) {
            if (!m.isCompatibleWith(mimeType)) continue;
            return true;
        }
        return false;
    }

    public Flux<DataBuffer> encode(Publisher<? extends Message> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (inputStream instanceof Mono) {
            return Mono.from(inputStream).map(value -> this.encodeValue((Message)value, bufferFactory, elementType, mimeType, hints)).flux();
        }
        JsonArrayJoinHelper helper = new JsonArrayJoinHelper();
        return Flux.from(inputStream).map(value -> {
            byte[] prefix = helper.getPrefix();
            byte[] delimiter = helper.getDelimiter();
            DataBuffer dataBuffer = this.encodeValue((Message)value, bufferFactory, MESSAGE_TYPE, mimeType, hints);
            return prefix.length > 0 ? bufferFactory.join(List.of(bufferFactory.wrap(prefix), bufferFactory.wrap(delimiter), dataBuffer)) : bufferFactory.join(List.of(bufferFactory.wrap(delimiter), dataBuffer));
        }).switchIfEmpty((Publisher)Mono.fromCallable(() -> bufferFactory.wrap(helper.getPrefix()))).concatWith((Publisher)Mono.fromCallable(() -> bufferFactory.wrap(helper.getSuffix())));
    }

    public DataBuffer encodeValue(Message message, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);
        try {
            this.printer.appendTo((MessageOrBuilder)message, (Appendable)writer);
            writer.flush();
            byte[] bytes = bos.toByteArrayUnsafe();
            return bufferFactory.wrap(bytes);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unexpected I/O error while writing to data buffer", ex);
        }
    }

    private static class JsonArrayJoinHelper {
        private static final byte[] COMMA_SEPARATOR = new byte[]{44};
        private static final byte[] OPEN_BRACKET = new byte[]{91};
        private static final byte[] CLOSE_BRACKET = new byte[]{93};
        private boolean firstItemEmitted;

        private JsonArrayJoinHelper() {
        }

        public byte[] getDelimiter() {
            if (this.firstItemEmitted) {
                return COMMA_SEPARATOR;
            }
            this.firstItemEmitted = true;
            return EMPTY_BYTES;
        }

        public byte[] getPrefix() {
            return this.firstItemEmitted ? EMPTY_BYTES : OPEN_BRACKET;
        }

        public byte[] getSuffix() {
            return CLOSE_BRACKET;
        }
    }
}

