/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import infra.core.ResolvableType;
import infra.core.codec.Encoder;
import infra.core.codec.EncodingException;
import infra.http.HttpHeaders;
import infra.http.MediaType;
import infra.http.ReactiveHttpOutputMessage;
import infra.http.codec.EncoderHttpMessageWriter;
import infra.http.codec.HttpMessageEncoder;
import infra.http.codec.protobuf.ProtobufEncoder;
import infra.lang.Nullable;
import infra.util.ConcurrentReferenceHashMap;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ProtobufHttpMessageWriter
extends EncoderHttpMessageWriter<Message> {
    private static final String X_PROTOBUF_SCHEMA_HEADER = "X-Protobuf-Schema";
    private static final String X_PROTOBUF_MESSAGE_HEADER = "X-Protobuf-Message";
    private static final ConcurrentReferenceHashMap<Class<?>, Method> methodCache = new ConcurrentReferenceHashMap();

    public ProtobufHttpMessageWriter() {
        super(new ProtobufEncoder());
    }

    public ProtobufHttpMessageWriter(Encoder<Message> encoder) {
        super(encoder);
    }

    @Override
    public Mono<Void> write(Publisher<? extends Message> inputStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage message, Map<String, Object> hints) {
        try {
            HttpHeaders headers = message.getHeaders();
            Message.Builder builder = ProtobufHttpMessageWriter.getMessageBuilder(elementType.toClass());
            Descriptors.Descriptor descriptor = builder.getDescriptorForType();
            headers.add(X_PROTOBUF_SCHEMA_HEADER, descriptor.getFile().getName());
            headers.add(X_PROTOBUF_MESSAGE_HEADER, descriptor.getFullName());
            if (inputStream instanceof Flux) {
                if (mediaType == null) {
                    headers.setContentType(((HttpMessageEncoder)this.getEncoder()).getStreamingMediaTypes().get(0));
                } else if (!"true".equals(mediaType.getParameters().get("delimited"))) {
                    HashMap<String, String> parameters = new HashMap<String, String>(mediaType.getParameters());
                    parameters.put("delimited", "true");
                    headers.setContentType(new MediaType(mediaType.getType(), mediaType.getSubtype(), parameters));
                }
            }
            return super.write(inputStream, elementType, mediaType, message, hints);
        }
        catch (Exception ex) {
            return Mono.error((Throwable)new EncodingException("Could not write Protobuf message: " + ex.getMessage(), (Throwable)ex));
        }
    }

    private static Message.Builder getMessageBuilder(Class<?> clazz) throws Exception {
        Method method = (Method)methodCache.get(clazz);
        if (method == null) {
            method = clazz.getMethod("newBuilder", new Class[0]);
            methodCache.put(clazz, (Object)method);
        }
        return (Message.Builder)method.invoke(clazz, new Object[0]);
    }
}

