/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec.protobuf;

import com.google.protobuf.Message;
import infra.core.ResolvableType;
import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.http.MediaType;
import infra.http.codec.HttpMessageEncoder;
import infra.http.codec.protobuf.ProtobufCodecSupport;
import infra.lang.Nullable;
import infra.util.FastByteArrayOutputStream;
import infra.util.MimeType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ProtobufEncoder
extends ProtobufCodecSupport
implements HttpMessageEncoder<Message> {
    private static final List<MediaType> streamingMediaTypes = MIME_TYPES.stream().map(mimeType -> new MediaType(mimeType.getType(), mimeType.getSubtype(), Collections.singletonMap("delimited", "true"))).collect(Collectors.toList());

    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return Message.class.isAssignableFrom(elementType.toClass()) && this.supportsMimeType(mimeType);
    }

    public Flux<DataBuffer> encode(Publisher<? extends Message> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.from(inputStream).map(message -> this.encodeValue((Message)message, bufferFactory, !(inputStream instanceof Mono)));
    }

    public DataBuffer encodeValue(Message message, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return this.encodeValue(message, bufferFactory, false);
    }

    private DataBuffer encodeValue(Message message, DataBufferFactory bufferFactory, boolean delimited) {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        try {
            if (delimited) {
                message.writeDelimitedTo((OutputStream)bos);
            } else {
                message.writeTo((OutputStream)bos);
            }
            byte[] bytes = bos.toByteArrayUnsafe();
            return bufferFactory.wrap(bytes);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unexpected I/O error while writing to data buffer", ex);
        }
    }

    @Override
    public List<MediaType> getStreamingMediaTypes() {
        return streamingMediaTypes;
    }

    public List<MimeType> getEncodableMimeTypes() {
        return this.getMimeTypes();
    }
}

