/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec.multipart;

import infra.core.ResolvableType;
import infra.core.codec.Hints;
import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.core.io.buffer.DataBufferUtils;
import infra.http.DefaultHttpHeaders;
import infra.http.MediaType;
import infra.http.ReactiveHttpOutputMessage;
import infra.http.codec.HttpMessageWriter;
import infra.http.codec.multipart.FilePart;
import infra.http.codec.multipart.MultipartHttpMessageReader;
import infra.http.codec.multipart.MultipartWriterSupport;
import infra.http.codec.multipart.Part;
import infra.lang.Nullable;
import infra.logging.Logger;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PartHttpMessageWriter
extends MultipartWriterSupport
implements HttpMessageWriter<Part> {
    public PartHttpMessageWriter() {
        super(MultipartHttpMessageReader.MIME_TYPES);
    }

    @Override
    public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
        if (Part.class.isAssignableFrom(elementType.toClass())) {
            if (mediaType == null) {
                return true;
            }
            for (MediaType supportedMediaType : this.getWritableMediaTypes()) {
                if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Mono<Void> write(Publisher<? extends Part> parts, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        byte[] boundary = this.generateMultipartBoundary();
        mediaType = this.getMultipartMediaType(mediaType, boundary);
        outputMessage.getHeaders().setContentType(mediaType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} Encoding Publisher<Part>", (Object)Hints.getLogPrefix(hints));
        }
        Flux body = Flux.from(parts).concatMap(part -> this.encodePart(boundary, (Part)part, outputMessage.bufferFactory())).concatWith(this.generateLastLine(boundary, outputMessage.bufferFactory())).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
        if (this.logger.isDebugEnabled()) {
            body = body.doOnNext(buffer -> Hints.touchDataBuffer((DataBuffer)buffer, (Map)hints, (Logger)this.logger));
        }
        return outputMessage.writeWith((Publisher<? extends DataBuffer>)body);
    }

    private Flux<DataBuffer> encodePart(byte[] boundary, Part part, DataBufferFactory bufferFactory) {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(part.headers());
        String name = part.name();
        if (!headers.containsKey("Content-Disposition")) {
            headers.setContentDispositionFormData(name, part instanceof FilePart ? ((FilePart)part).filename() : null);
        }
        return Flux.concat((Publisher[])new Publisher[]{this.generateBoundaryLine(boundary, bufferFactory), this.generatePartHeaders(headers, bufferFactory), part.content(), this.generateNewLine(bufferFactory)});
    }
}

