/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec.multipart;

import infra.core.ResolvableType;
import infra.core.codec.DecodingException;
import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferLimitException;
import infra.core.io.buffer.DataBufferUtils;
import infra.http.HttpHeaders;
import infra.http.MediaType;
import infra.http.ReactiveHttpInputMessage;
import infra.http.codec.HttpMessageReader;
import infra.http.codec.LoggingCodecSupport;
import infra.http.codec.multipart.DefaultPartEvents;
import infra.http.codec.multipart.MultipartParser;
import infra.http.codec.multipart.MultipartUtils;
import infra.http.codec.multipart.PartEvent;
import infra.lang.Assert;
import infra.lang.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PartEventHttpMessageReader
extends LoggingCodecSupport
implements HttpMessageReader<PartEvent> {
    private int maxInMemorySize = 262144;
    private int maxHeadersSize = 10240;
    private int maxParts = -1;
    private long maxPartSize = -1L;
    private Charset headersCharset = StandardCharsets.UTF_8;

    public int getMaxInMemorySize() {
        return this.maxInMemorySize;
    }

    public void setMaxInMemorySize(int maxInMemorySize) {
        this.maxInMemorySize = maxInMemorySize;
    }

    public void setMaxHeadersSize(int byteCount) {
        this.maxHeadersSize = byteCount;
    }

    public void setMaxParts(int maxParts) {
        this.maxParts = maxParts;
    }

    public void setMaxPartSize(long maxPartSize) {
        this.maxPartSize = maxPartSize;
    }

    public void setHeadersCharset(Charset headersCharset) {
        Assert.notNull((Object)headersCharset, (String)"Charset is required");
        this.headersCharset = headersCharset;
    }

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return Collections.singletonList(MediaType.MULTIPART_FORM_DATA);
    }

    @Override
    public boolean canRead(ResolvableType elementType, @Nullable MediaType mediaType) {
        return PartEvent.class.equals((Object)elementType.toClass()) && (mediaType == null || MediaType.MULTIPART_FORM_DATA.isCompatibleWith(mediaType));
    }

    @Override
    public Mono<PartEvent> readMono(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        return Mono.error((Throwable)new UnsupportedOperationException("Cannot read multipart request body into single PartEvent"));
    }

    @Override
    public Flux<PartEvent> read(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        return Flux.defer(() -> {
            byte[] boundary = MultipartUtils.boundary(message, this.headersCharset);
            if (boundary == null) {
                return Flux.error((Throwable)new DecodingException("No multipart boundary found in Content-Type: \"%s\"".formatted(message.getHeaders().getContentType())));
            }
            Flux<MultipartParser.Token> allPartsTokens = MultipartParser.parse(message.getBody(), boundary, this.maxHeadersSize, this.headersCharset);
            AtomicInteger partCount = new AtomicInteger();
            return allPartsTokens.windowUntil(t -> t instanceof MultipartParser.HeadersToken, true).concatMap(partTokens -> partTokens.switchOnFirst((signal, flux) -> {
                if (!signal.hasValue()) {
                    return flux.cast(PartEvent.class);
                }
                if (this.tooManyParts(partCount)) {
                    return Mono.error((Throwable)new DecodingException("Too many parts (%s/%s allowed)".formatted(partCount.get(), this.maxParts)));
                }
                MultipartParser.HeadersToken headersToken = (MultipartParser.HeadersToken)signal.get();
                Assert.state((headersToken != null ? 1 : 0) != 0, (String)"Signal should be headers token");
                HttpHeaders headers = headersToken.getHeaders();
                return this.createEvents(headers, (Flux<MultipartParser.BodyToken>)flux.ofType(MultipartParser.BodyToken.class));
            }));
        });
    }

    private boolean tooManyParts(AtomicInteger partCount) {
        int count = partCount.incrementAndGet();
        return this.maxParts > 0 && count > this.maxParts;
    }

    private Publisher<? extends PartEvent> createEvents(HttpHeaders headers, Flux<MultipartParser.BodyToken> bodyTokens) {
        if (MultipartUtils.isFormField(headers)) {
            Flux contents = bodyTokens.map(MultipartParser.BodyToken::getBuffer);
            int maxSize = this.maxPartSize == -1L ? this.maxInMemorySize : (int)Math.min((long)this.maxInMemorySize, this.maxPartSize);
            return DataBufferUtils.join((Publisher)contents, (int)maxSize).map(content -> {
                String value = content.toString(MultipartUtils.charset(headers));
                DataBufferUtils.release((DataBuffer)content);
                return DefaultPartEvents.form(headers, value);
            }).switchIfEmpty(Mono.fromCallable(() -> DefaultPartEvents.form(headers)));
        }
        boolean isFilePart = headers.getContentDisposition().getFilename() != null;
        AtomicLong partSize = new AtomicLong();
        return bodyTokens.concatMap(body -> {
            DataBuffer buffer = body.getBuffer();
            if (this.tooLarge(partSize, buffer)) {
                DataBufferUtils.release((DataBuffer)buffer);
                return Mono.error((Throwable)new DataBufferLimitException("Part exceeded the limit of %s bytes".formatted(this.maxPartSize)));
            }
            return isFilePart ? Mono.just((Object)DefaultPartEvents.file(headers, buffer, body.isLast())) : Mono.just((Object)DefaultPartEvents.create(headers, body.getBuffer(), body.isLast()));
        }).switchIfEmpty((Publisher)Mono.fromCallable(() -> isFilePart ? DefaultPartEvents.file(headers) : DefaultPartEvents.create(headers)));
    }

    private boolean tooLarge(AtomicLong partSize, DataBuffer buffer) {
        if (this.maxPartSize != -1L) {
            long size = partSize.addAndGet(buffer.readableByteCount());
            return size > this.maxPartSize;
        }
        return false;
    }
}

