/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec.multipart;

import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.http.HttpHeaders;
import infra.http.MediaType;
import infra.http.codec.LoggingCodecSupport;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.util.FastByteArrayOutputStream;
import infra.util.MimeTypeUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public class MultipartWriterSupport
extends LoggingCodecSupport {
    private final List<MediaType> supportedMediaTypes;
    private Charset charset = Constant.DEFAULT_CHARSET;

    protected MultipartWriterSupport(List<MediaType> supportedMediaTypes) {
        this.supportedMediaTypes = supportedMediaTypes;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        Assert.notNull((Object)charset, (String)"Charset is required");
        this.charset = charset;
    }

    public List<MediaType> getWritableMediaTypes() {
        return this.supportedMediaTypes;
    }

    protected byte[] generateMultipartBoundary() {
        return MimeTypeUtils.generateMultipartBoundary();
    }

    protected MediaType getMultipartMediaType(@Nullable MediaType mediaType, byte[] boundary) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (mediaType != null) {
            params.putAll(mediaType.getParameters());
        }
        params.put("boundary", new String(boundary, StandardCharsets.US_ASCII));
        Charset charset = this.getCharset();
        if (!charset.equals(StandardCharsets.UTF_8) && !charset.equals(StandardCharsets.US_ASCII)) {
            params.put("charset", charset.name());
        }
        mediaType = mediaType != null ? mediaType : MediaType.MULTIPART_FORM_DATA;
        mediaType = new MediaType(mediaType, params);
        return mediaType;
    }

    protected Mono<DataBuffer> generateBoundaryLine(byte[] boundary, DataBufferFactory bufferFactory) {
        return Mono.fromCallable(() -> {
            DataBuffer buffer = bufferFactory.allocateBuffer(boundary.length + 4);
            buffer.write((byte)45);
            buffer.write((byte)45);
            buffer.write(boundary);
            buffer.write((byte)13);
            buffer.write((byte)10);
            return buffer;
        });
    }

    protected Mono<DataBuffer> generateNewLine(DataBufferFactory bufferFactory) {
        return Mono.fromCallable(() -> {
            DataBuffer buffer = bufferFactory.allocateBuffer(2);
            buffer.write((byte)13);
            buffer.write((byte)10);
            return buffer;
        });
    }

    protected Mono<DataBuffer> generateLastLine(byte[] boundary, DataBufferFactory bufferFactory) {
        return Mono.fromCallable(() -> {
            DataBuffer buffer = bufferFactory.allocateBuffer(boundary.length + 6);
            buffer.write((byte)45);
            buffer.write((byte)45);
            buffer.write(boundary);
            buffer.write((byte)45);
            buffer.write((byte)45);
            buffer.write((byte)13);
            buffer.write((byte)10);
            return buffer;
        });
    }

    protected Mono<DataBuffer> generatePartHeaders(HttpHeaders headers, DataBufferFactory bufferFactory) {
        return Mono.fromCallable(() -> {
            FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
            for (Map.Entry entry : headers.entrySet()) {
                byte[] headerName = ((String)entry.getKey()).getBytes(this.getCharset());
                for (String headerValueString : (List)entry.getValue()) {
                    byte[] headerValue = headerValueString.getBytes(this.getCharset());
                    bos.write(headerName);
                    bos.write(58);
                    bos.write(32);
                    bos.write(headerValue);
                    bos.write(13);
                    bos.write(10);
                }
            }
            bos.write(13);
            bos.write(10);
            byte[] bytes = bos.toByteArrayUnsafe();
            return bufferFactory.wrap(bytes);
        });
    }
}

