/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec.multipart;

import infra.core.ResolvableType;
import infra.core.ResolvableTypeProvider;
import infra.core.codec.CharSequenceEncoder;
import infra.core.codec.CodecException;
import infra.core.codec.Hints;
import infra.core.io.Resource;
import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.core.io.buffer.DataBufferUtils;
import infra.http.HttpEntity;
import infra.http.HttpHeaders;
import infra.http.MediaType;
import infra.http.ReactiveHttpOutputMessage;
import infra.http.codec.EncoderHttpMessageWriter;
import infra.http.codec.FormHttpMessageWriter;
import infra.http.codec.HttpMessageWriter;
import infra.http.codec.ResourceHttpMessageWriter;
import infra.http.codec.multipart.MultipartHttpMessageReader;
import infra.http.codec.multipart.MultipartWriterSupport;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.util.LogFormatUtils;
import infra.util.MultiValueMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MultipartHttpMessageWriter
extends MultipartWriterSupport
implements HttpMessageWriter<MultiValueMap<String, ?>> {
    private static final Map<String, Object> DEFAULT_HINTS = Hints.from((String)Hints.SUPPRESS_LOGGING_HINT, (Object)true);
    private final Supplier<List<HttpMessageWriter<?>>> partWritersSupplier;
    @Nullable
    private final HttpMessageWriter<MultiValueMap<String, String>> formWriter;

    public MultipartHttpMessageWriter() {
        this(Arrays.asList(new EncoderHttpMessageWriter(CharSequenceEncoder.textPlainOnly()), new ResourceHttpMessageWriter()));
    }

    public MultipartHttpMessageWriter(List<HttpMessageWriter<?>> partWriters) {
        this(partWriters, (HttpMessageWriter<MultiValueMap<String, String>>)new FormHttpMessageWriter());
    }

    public MultipartHttpMessageWriter(List<HttpMessageWriter<?>> partWriters, @Nullable HttpMessageWriter<MultiValueMap<String, String>> formWriter) {
        this(() -> partWriters, formWriter);
    }

    public MultipartHttpMessageWriter(Supplier<List<HttpMessageWriter<?>>> partWritersSupplier, @Nullable HttpMessageWriter<MultiValueMap<String, String>> formWriter) {
        super(MultipartHttpMessageWriter.initMediaTypes(formWriter));
        this.partWritersSupplier = partWritersSupplier;
        this.formWriter = formWriter;
    }

    private static List<MediaType> initMediaTypes(@Nullable HttpMessageWriter<?> formWriter) {
        ArrayList<MediaType> result = new ArrayList<MediaType>(MultipartHttpMessageReader.MIME_TYPES);
        if (formWriter != null) {
            result.addAll(formWriter.getWritableMediaTypes());
        }
        return Collections.unmodifiableList(result);
    }

    public List<HttpMessageWriter<?>> getPartWriters() {
        return Collections.unmodifiableList(this.partWritersSupplier.get());
    }

    @Nullable
    public HttpMessageWriter<MultiValueMap<String, String>> getFormWriter() {
        return this.formWriter;
    }

    @Override
    public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
        if (MultiValueMap.class.isAssignableFrom(elementType.toClass())) {
            if (mediaType == null) {
                return true;
            }
            for (MediaType supportedMediaType : this.getWritableMediaTypes()) {
                if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Mono<Void> write(Publisher<? extends MultiValueMap<String, ?>> inputStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        return Mono.from(inputStream).flatMap(map -> {
            if (this.formWriter == null || this.isMultipart((MultiValueMap<String, ?>)map, mediaType)) {
                return this.writeMultipart((MultiValueMap<String, ?>)map, outputMessage, mediaType, hints);
            }
            Mono input = Mono.just((Object)map);
            return this.formWriter.write((Publisher<MultiValueMap<String, String>>)input, elementType, mediaType, outputMessage, hints);
        });
    }

    private boolean isMultipart(MultiValueMap<String, ?> map, @Nullable MediaType contentType) {
        if (contentType != null) {
            return contentType.getType().equalsIgnoreCase("multipart");
        }
        for (List values : map.values()) {
            for (Object value : values) {
                if (value == null || value instanceof String) continue;
                return true;
            }
        }
        return false;
    }

    private Mono<Void> writeMultipart(MultiValueMap<String, ?> map, ReactiveHttpOutputMessage outputMessage, @Nullable MediaType mediaType, Map<String, Object> hints) {
        byte[] boundary = this.generateMultipartBoundary();
        mediaType = this.getMultipartMediaType(mediaType, boundary);
        outputMessage.getHeaders().setContentType(mediaType);
        if (this.logger.isDebugEnabled()) {
            LogFormatUtils.traceDebug((Logger)this.logger, traceOn -> Hints.getLogPrefix((Map)hints) + "Encoding " + (String)(this.isEnableLoggingRequestDetails() ? LogFormatUtils.formatValue((Object)map, (traceOn == false ? 1 : 0) != 0) : "parts " + map.keySet() + " (content masked)"));
        }
        DataBufferFactory bufferFactory = outputMessage.bufferFactory();
        Flux body = Flux.fromIterable((Iterable)map.entrySet()).concatMap(entry -> this.encodePartValues(boundary, (String)entry.getKey(), (List)entry.getValue(), bufferFactory)).concatWith(this.generateLastLine(boundary, bufferFactory)).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
        if (this.logger.isDebugEnabled()) {
            body = body.doOnNext(buffer -> Hints.touchDataBuffer((DataBuffer)buffer, (Map)hints, (Logger)this.logger));
        }
        return outputMessage.writeWith((Publisher<? extends DataBuffer>)body);
    }

    private Flux<DataBuffer> encodePartValues(byte[] boundary, String name, List<?> values, DataBufferFactory bufferFactory) {
        return Flux.fromIterable(values).concatMap(value -> this.encodePart(boundary, name, value, bufferFactory));
    }

    private <T> Flux<DataBuffer> encodePart(byte[] boundary, String name, T value, DataBufferFactory factory) {
        Object body;
        MultipartHttpOutputMessage message = new MultipartHttpOutputMessage(factory);
        HttpHeaders headers = message.getHeaders();
        ResolvableType resolvableType = null;
        if (value instanceof HttpEntity) {
            HttpEntity httpEntity = (HttpEntity)value;
            headers.putAll((Map)((Object)httpEntity.getHeaders()));
            body = httpEntity.getBody();
            Assert.state((body != null ? 1 : 0) != 0, (String)"MultipartHttpMessageWriter only supports HttpEntity with body");
            if (httpEntity instanceof ResolvableTypeProvider) {
                ResolvableTypeProvider provider = (ResolvableTypeProvider)httpEntity;
                resolvableType = provider.getResolvableType();
            }
        } else {
            body = value;
        }
        if (resolvableType == null) {
            resolvableType = ResolvableType.forClass(body.getClass());
        }
        if (!headers.containsKey("Content-Disposition")) {
            if (body instanceof Resource) {
                Resource resource = (Resource)body;
                headers.setContentDispositionFormData(name, resource.getName());
            } else if (resolvableType.resolve() == Resource.class) {
                body = Mono.from((Publisher)((Publisher)body)).doOnNext(res -> headers.setContentDispositionFormData(name, res.getName()));
            } else {
                headers.setContentDispositionFormData(name, null);
            }
        }
        MediaType contentType = headers.getContentType();
        ResolvableType finalBodyType = resolvableType;
        for (HttpMessageWriter<?> partWriter : this.partWritersSupplier.get()) {
            if (!partWriter.canWrite(finalBodyType, contentType)) continue;
            Publisher inputStream = body instanceof Publisher ? (Publisher)body : Mono.just(body);
            Flux partContent = partWriter.write(inputStream, resolvableType, contentType, message, DEFAULT_HINTS).thenMany((Publisher)Flux.defer(message::getBody));
            return Flux.concat((Publisher[])new Publisher[]{this.generateBoundaryLine(boundary, factory), partContent, this.generateNewLine(factory)});
        }
        return Flux.error((Throwable)new CodecException("No suitable writer found for part: " + name));
    }

    private class MultipartHttpOutputMessage
    implements ReactiveHttpOutputMessage {
        private final DataBufferFactory bufferFactory;
        private final HttpHeaders headers = HttpHeaders.forWritable();
        private final AtomicBoolean committed = new AtomicBoolean();
        @Nullable
        private Flux<DataBuffer> body;

        public MultipartHttpOutputMessage(DataBufferFactory bufferFactory) {
            this.bufferFactory = bufferFactory;
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.body != null ? this.headers.asReadOnly() : this.headers;
        }

        @Override
        public DataBufferFactory bufferFactory() {
            return this.bufferFactory;
        }

        @Override
        public void beforeCommit(Supplier<? extends Mono<Void>> action) {
            this.committed.set(true);
        }

        @Override
        public boolean isCommitted() {
            return this.committed.get();
        }

        @Override
        public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
            if (this.body != null) {
                return Mono.error((Throwable)new IllegalStateException("Multiple calls to writeWith() not supported"));
            }
            this.body = MultipartHttpMessageWriter.this.generatePartHeaders(this.headers, this.bufferFactory).concatWith(body);
            return Mono.empty();
        }

        @Override
        public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
            return Mono.error((Throwable)new UnsupportedOperationException());
        }

        public Flux<DataBuffer> getBody() {
            return this.body != null ? this.body : Flux.error((Throwable)new IllegalStateException("Body has not been written yet"));
        }

        @Override
        public Mono<Void> setComplete() {
            return Mono.error((Throwable)new UnsupportedOperationException());
        }
    }
}

