/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec.multipart;

import infra.core.ResolvableType;
import infra.core.codec.Hints;
import infra.http.MediaType;
import infra.http.ReactiveHttpInputMessage;
import infra.http.codec.HttpMessageReader;
import infra.http.codec.LoggingCodecSupport;
import infra.http.codec.multipart.Part;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.util.LinkedMultiValueMap;
import infra.util.LogFormatUtils;
import infra.util.MultiValueMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MultipartHttpMessageReader
extends LoggingCodecSupport
implements HttpMessageReader<MultiValueMap<String, Part>> {
    private static final ResolvableType MULTIPART_VALUE_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, Part.class});
    static final List<MediaType> MIME_TYPES = List.of(MediaType.MULTIPART_FORM_DATA, MediaType.MULTIPART_MIXED, MediaType.MULTIPART_RELATED);
    private final HttpMessageReader<Part> partReader;

    public MultipartHttpMessageReader(HttpMessageReader<Part> partReader) {
        Assert.notNull(partReader, (String)"'partReader' is required");
        this.partReader = partReader;
    }

    public HttpMessageReader<Part> getPartReader() {
        return this.partReader;
    }

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return MIME_TYPES;
    }

    @Override
    public boolean canRead(ResolvableType elementType, @Nullable MediaType mediaType) {
        if (MULTIPART_VALUE_TYPE.isAssignableFrom(elementType)) {
            if (mediaType == null) {
                return true;
            }
            for (MediaType supportedMediaType : MIME_TYPES) {
                if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Flux<MultiValueMap<String, Part>> read(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        return Flux.from(this.readMono(elementType, message, hints));
    }

    @Override
    public Mono<MultiValueMap<String, Part>> readMono(ResolvableType elementType, ReactiveHttpInputMessage inputMessage, Map<String, Object> hints) {
        Map allHints = Hints.merge(hints, (String)Hints.SUPPRESS_LOGGING_HINT, (Object)true);
        if (this.logger.isDebugEnabled()) {
            return this.partReader.read(elementType, inputMessage, allHints).collectMultimap(Part::name).doOnNext(map -> LogFormatUtils.traceDebug((Logger)this.logger, traceOn -> Hints.getLogPrefix((Map)hints) + "Parsed " + (String)(this.isEnableLoggingRequestDetails() ? LogFormatUtils.formatValue((Object)map, (traceOn == false ? 1 : 0) != 0) : "parts " + map.keySet() + " (content masked)"))).map(this::toMultiValueMap);
        }
        return this.partReader.read(elementType, inputMessage, allHints).collectMultimap(Part::name).map(this::toMultiValueMap);
    }

    private LinkedMultiValueMap<String, Part> toMultiValueMap(Map<String, Collection<Part>> map) {
        LinkedMultiValueMap ret = MultiValueMap.forLinkedHashMap((int)map.size());
        for (Map.Entry<String, Collection<Part>> entry : map.entrySet()) {
            ret.put((Object)entry.getKey(), this.toList(entry.getValue()));
        }
        return ret;
    }

    private List<Part> toList(Collection<Part> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList<Part>(collection);
    }
}

