/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec.multipart;

import infra.http.ContentDisposition;
import infra.http.DefaultHttpHeaders;
import infra.http.HttpHeaders;
import infra.http.MediaType;
import infra.http.codec.multipart.DefaultPartEvents;
import infra.http.codec.multipart.PartEvent;
import infra.lang.Assert;
import infra.lang.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

public interface FormPartEvent
extends PartEvent {
    public String value();

    public static Mono<FormPartEvent> create(String name, String value) {
        return FormPartEvent.create(name, value, null);
    }

    public static Mono<FormPartEvent> create(String name, String value, @Nullable Consumer<HttpHeaders> headersConsumer) {
        Assert.hasLength((String)name, (String)"Name must not be empty");
        Assert.notNull((Object)value, (String)"Value is required");
        return Mono.fromCallable(() -> {
            DefaultHttpHeaders headers = HttpHeaders.forWritable();
            headers.setContentType(MediaType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8));
            headers.setContentDisposition(ContentDisposition.formData().name(name).build());
            if (headersConsumer != null) {
                headersConsumer.accept(headers);
            }
            return DefaultPartEvents.form(headers, value);
        });
    }
}

