/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec.multipart;

import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DefaultDataBufferFactory;
import infra.http.HttpHeaders;
import infra.http.codec.multipart.FilePartEvent;
import infra.http.codec.multipart.FormPartEvent;
import infra.http.codec.multipart.MultipartUtils;
import infra.http.codec.multipart.PartEvent;
import infra.lang.Assert;

abstract class DefaultPartEvents {
    DefaultPartEvents() {
    }

    public static FormPartEvent form(HttpHeaders headers) {
        Assert.notNull((Object)headers, (String)"Headers is required");
        return new DefaultFormFieldPartEvent(headers);
    }

    public static FormPartEvent form(HttpHeaders headers, String value) {
        Assert.notNull((Object)headers, (String)"Headers is required");
        Assert.notNull((Object)value, (String)"Value is required");
        return new DefaultFormFieldPartEvent(headers, value);
    }

    public static FilePartEvent file(HttpHeaders headers, DataBuffer dataBuffer, boolean isLast) {
        Assert.notNull((Object)headers, (String)"Headers is required");
        Assert.notNull((Object)dataBuffer, (String)"DataBuffer is required");
        return new DefaultFilePartEvent(headers, dataBuffer, isLast);
    }

    public static FilePartEvent file(HttpHeaders headers) {
        Assert.notNull((Object)headers, (String)"Headers is required");
        return new DefaultFilePartEvent(headers);
    }

    public static PartEvent create(HttpHeaders headers, DataBuffer dataBuffer, boolean isLast) {
        Assert.notNull((Object)headers, (String)"Headers is required");
        Assert.notNull((Object)dataBuffer, (String)"DataBuffer is required");
        if (headers.getContentDisposition().getFilename() != null) {
            return DefaultPartEvents.file(headers, dataBuffer, isLast);
        }
        return new DefaultPartEvent(headers, dataBuffer, isLast);
    }

    public static PartEvent create(HttpHeaders headers) {
        Assert.notNull((Object)headers, (String)"Headers is required");
        if (headers.getContentDisposition().getFilename() != null) {
            return DefaultPartEvents.file(headers);
        }
        return new DefaultPartEvent(headers);
    }

    private static final class DefaultFormFieldPartEvent
    extends AbstractPartEvent
    implements FormPartEvent {
        private static final String EMPTY = "";
        private final String value;

        public DefaultFormFieldPartEvent(HttpHeaders headers) {
            this(headers, EMPTY);
        }

        public DefaultFormFieldPartEvent(HttpHeaders headers, String value) {
            super(headers);
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public DataBuffer content() {
            byte[] bytes = this.value.getBytes(MultipartUtils.charset(this.headers()));
            return DefaultDataBufferFactory.sharedInstance.wrap(bytes);
        }

        @Override
        public boolean isLast() {
            return true;
        }
    }

    private static class DefaultFilePartEvent
    extends DefaultPartEvent
    implements FilePartEvent {
        public DefaultFilePartEvent(HttpHeaders headers) {
            super(headers);
        }

        public DefaultFilePartEvent(HttpHeaders headers, DataBuffer content, boolean last) {
            super(headers, content, last);
        }
    }

    private static class DefaultPartEvent
    extends AbstractPartEvent {
        private static final DataBuffer EMPTY = DefaultDataBufferFactory.sharedInstance.allocateBuffer(0);
        private final DataBuffer content;
        private final boolean last;

        public DefaultPartEvent(HttpHeaders headers) {
            this(headers, EMPTY, true);
        }

        public DefaultPartEvent(HttpHeaders headers, DataBuffer content, boolean last) {
            super(headers);
            this.content = content;
            this.last = last;
        }

        @Override
        public DataBuffer content() {
            return this.content;
        }

        @Override
        public boolean isLast() {
            return this.last;
        }
    }

    private static abstract class AbstractPartEvent
    implements PartEvent {
        private final HttpHeaders headers;

        protected AbstractPartEvent(HttpHeaders headers) {
            this.headers = headers.asReadOnly();
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }
    }
}

