/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import infra.http.MediaType;
import infra.http.codec.json.AbstractJackson2Encoder;
import infra.http.converter.json.Jackson2ObjectMapperBuilder;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.util.MimeType;
import java.util.Collections;

public class Jackson2SmileEncoder
extends AbstractJackson2Encoder {
    static final MimeType[] DEFAULT_SMILE_MIME_TYPES = new MimeType[]{new MimeType("application", "x-jackson-smile"), new MimeType("application", "*+x-jackson-smile")};
    private static final byte[] STREAM_SEPARATOR = Constant.EMPTY_BYTES;

    public Jackson2SmileEncoder() {
        this((ObjectMapper)Jackson2ObjectMapperBuilder.smile().build(), DEFAULT_SMILE_MIME_TYPES);
    }

    public Jackson2SmileEncoder(ObjectMapper mapper, MimeType ... mimeTypes) {
        super(mapper, mimeTypes);
        Assert.isAssignable(SmileFactory.class, mapper.getFactory().getClass());
        this.setStreamingMediaTypes(Collections.singletonList(new MediaType("application", "stream+x-jackson-smile")));
    }

    @Override
    @Nullable
    protected byte[] getStreamingMediaTypeSeparator(@Nullable MimeType mimeType) {
        for (MediaType streamingMediaType : this.getStreamingMediaTypes()) {
            if (!streamingMediaType.isCompatibleWith(mimeType)) continue;
            return STREAM_SEPARATOR;
        }
        return null;
    }
}

