/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec;

import infra.core.ResolvableType;
import infra.core.codec.Hints;
import infra.core.codec.ResourceDecoder;
import infra.core.io.Resource;
import infra.http.ReactiveHttpInputMessage;
import infra.http.codec.DecoderHttpMessageReader;
import infra.http.server.reactive.ServerHttpRequest;
import infra.http.server.reactive.ServerHttpResponse;
import infra.util.StringUtils;
import java.util.Map;

public class ResourceHttpMessageReader
extends DecoderHttpMessageReader<Resource> {
    public ResourceHttpMessageReader() {
        super(new ResourceDecoder());
    }

    public ResourceHttpMessageReader(ResourceDecoder resourceDecoder) {
        super(resourceDecoder);
    }

    @Override
    protected Map<String, Object> getReadHints(ResolvableType elementType, ReactiveHttpInputMessage message) {
        String filename = message.getHeaders().getContentDisposition().getFilename();
        return StringUtils.hasText((String)filename) ? Hints.from((String)ResourceDecoder.FILENAME_HINT, (Object)filename) : Hints.none();
    }

    @Override
    protected Map<String, Object> getReadHints(ResolvableType actualType, ResolvableType elementType, ServerHttpRequest request, ServerHttpResponse response) {
        return this.getReadHints(elementType, request);
    }
}

