/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec;

import infra.core.ResolvableType;
import infra.core.codec.Hints;
import infra.core.io.buffer.DataBuffer;
import infra.http.MediaType;
import infra.http.ReactiveHttpOutputMessage;
import infra.http.codec.HttpMessageWriter;
import infra.http.codec.LoggingCodecSupport;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.util.LogFormatUtils;
import infra.util.MultiValueMap;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class FormHttpMessageWriter
extends LoggingCodecSupport
implements HttpMessageWriter<MultiValueMap<String, String>> {
    private static final List<MediaType> MEDIA_TYPES = Collections.singletonList(MediaType.APPLICATION_FORM_URLENCODED);
    private static final ResolvableType MULTI_VALUE_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, String.class});
    private Charset defaultCharset = StandardCharsets.UTF_8;

    public void setDefaultCharset(Charset charset) {
        Assert.notNull((Object)charset, (String)"Charset is required");
        this.defaultCharset = charset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    @Override
    public List<MediaType> getWritableMediaTypes() {
        return MEDIA_TYPES;
    }

    @Override
    public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
        if (MultiValueMap.class.isAssignableFrom(elementType.toClass())) {
            if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(mediaType)) {
                return true;
            }
            if (mediaType == null) {
                return MULTI_VALUE_TYPE.isAssignableFrom(elementType);
            }
        }
        return false;
    }

    @Override
    public Mono<Void> write(Publisher<? extends MultiValueMap<String, String>> inputStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage message, Map<String, Object> hints) {
        mediaType = this.getMediaType(mediaType);
        message.getHeaders().setContentType(mediaType);
        Charset charset = mediaType.getCharset() != null ? mediaType.getCharset() : this.getDefaultCharset();
        return Mono.from(inputStream).flatMap(form -> {
            if (this.logger.isDebugEnabled()) {
                this.logFormData((MultiValueMap<String, String>)form, hints);
            }
            String value = this.serializeForm((MultiValueMap<String, String>)form, charset);
            ByteBuffer byteBuffer = charset.encode(value);
            DataBuffer buffer = message.bufferFactory().wrap(byteBuffer);
            message.getHeaders().setContentLength(byteBuffer.remaining());
            return message.writeWith((Publisher<? extends DataBuffer>)Mono.just((Object)buffer));
        });
    }

    protected MediaType getMediaType(@Nullable MediaType mediaType) {
        Charset defaultCharset;
        if (mediaType == null) {
            return MediaType.APPLICATION_FORM_URLENCODED;
        }
        if (mediaType.getCharset() == null && (defaultCharset = this.getDefaultCharset()) != Constant.DEFAULT_CHARSET) {
            return mediaType.withCharset(defaultCharset);
        }
        return mediaType;
    }

    private void logFormData(MultiValueMap<String, String> form, Map<String, Object> hints) {
        LogFormatUtils.traceDebug((Logger)this.logger, traceOn -> Hints.getLogPrefix((Map)hints) + "Writing " + (String)(this.isEnableLoggingRequestDetails() ? LogFormatUtils.formatValue((Object)form, (traceOn == false ? 1 : 0) != 0) : "form fields " + form.keySet() + " (content masked)"));
    }

    protected String serializeForm(MultiValueMap<String, String> formData, Charset charset) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : formData.entrySet()) {
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            for (String value : values) {
                if (!builder.isEmpty()) {
                    builder.append('&');
                }
                builder.append(URLEncoder.encode(name, charset));
                if (value == null) continue;
                builder.append('=');
                builder.append(URLEncoder.encode(value, charset));
            }
        }
        return builder.toString();
    }
}

