/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec;

import infra.core.ResolvableType;
import infra.core.codec.Hints;
import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferUtils;
import infra.http.MediaType;
import infra.http.ReactiveHttpInputMessage;
import infra.http.codec.HttpMessageReader;
import infra.http.codec.LoggingCodecSupport;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.util.LinkedMultiValueMap;
import infra.util.LogFormatUtils;
import infra.util.MultiValueMap;
import infra.util.StringUtils;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FormHttpMessageReader
extends LoggingCodecSupport
implements HttpMessageReader<MultiValueMap<String, String>> {
    private static final ResolvableType MULTIVALUE_STRINGS_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, String.class});
    private Charset defaultCharset = Constant.DEFAULT_CHARSET;
    private int maxInMemorySize = 262144;

    public void setDefaultCharset(Charset charset) {
        Assert.notNull((Object)charset, (String)"Charset is required");
        this.defaultCharset = charset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setMaxInMemorySize(int byteCount) {
        this.maxInMemorySize = byteCount;
    }

    public int getMaxInMemorySize() {
        return this.maxInMemorySize;
    }

    @Override
    public boolean canRead(ResolvableType elementType, @Nullable MediaType mediaType) {
        boolean multiValueUnresolved = elementType.hasUnresolvableGenerics() && MultiValueMap.class.isAssignableFrom(elementType.toClass());
        return !(!MULTIVALUE_STRINGS_TYPE.isAssignableFrom(elementType) && !multiValueUnresolved || mediaType != null && !MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(mediaType));
    }

    @Override
    public Flux<MultiValueMap<String, String>> read(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        return Flux.from(this.readMono(elementType, message, hints));
    }

    @Override
    public Mono<MultiValueMap<String, String>> readMono(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        MediaType contentType = message.getHeaders().getContentType();
        Charset charset = this.getMediaTypeCharset(contentType);
        return DataBufferUtils.join(message.getBody(), (int)this.maxInMemorySize).map(buffer -> {
            String body = buffer.toString(charset);
            DataBufferUtils.release((DataBuffer)buffer);
            MultiValueMap<String, String> formData = this.parseFormData(charset, body);
            if (this.logger.isDebugEnabled()) {
                this.logFormData(formData, hints);
            }
            return formData;
        });
    }

    private void logFormData(MultiValueMap<String, String> formData, Map<String, Object> hints) {
        LogFormatUtils.traceDebug((Logger)this.logger, traceOn -> Hints.getLogPrefix((Map)hints) + "Read " + (String)(this.isEnableLoggingRequestDetails() ? LogFormatUtils.formatValue((Object)formData, (traceOn == false ? 1 : 0) != 0) : "form fields " + formData.keySet() + " (content masked)"));
    }

    private Charset getMediaTypeCharset(@Nullable MediaType mediaType) {
        if (mediaType != null && mediaType.getCharset() != null) {
            return mediaType.getCharset();
        }
        return this.getDefaultCharset();
    }

    private MultiValueMap<String, String> parseFormData(Charset charset, String body) {
        String[] pairs = StringUtils.tokenizeToStringArray((String)body, (String)"&");
        LinkedMultiValueMap result = MultiValueMap.forLinkedHashMap((int)pairs.length);
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) {
                result.add((Object)URLDecoder.decode(pair, charset), null);
                continue;
            }
            String name = URLDecoder.decode(pair.substring(0, idx), charset);
            String value = URLDecoder.decode(pair.substring(idx + 1), charset);
            result.add((Object)name, (Object)value);
        }
        return result;
    }

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return Collections.singletonList(MediaType.APPLICATION_FORM_URLENCODED);
    }
}

