/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec;

import infra.core.ResolvableType;
import infra.core.codec.AbstractEncoder;
import infra.core.codec.Encoder;
import infra.core.codec.Hints;
import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferUtils;
import infra.http.HttpLogging;
import infra.http.MediaType;
import infra.http.ReactiveHttpOutputMessage;
import infra.http.codec.HttpMessageEncoder;
import infra.http.codec.HttpMessageWriter;
import infra.http.server.reactive.ServerHttpRequest;
import infra.http.server.reactive.ServerHttpResponse;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.util.MimeType;
import infra.util.StringUtils;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EncoderHttpMessageWriter<T>
implements HttpMessageWriter<T> {
    private static final Logger logger = HttpLogging.forLogName(EncoderHttpMessageWriter.class);
    private final Encoder<T> encoder;
    private final List<MediaType> mediaTypes;
    @Nullable
    private final MediaType defaultMediaType;

    public EncoderHttpMessageWriter(Encoder<T> encoder) {
        Assert.notNull(encoder, (String)"Encoder is required");
        EncoderHttpMessageWriter.initLogger(encoder);
        this.encoder = encoder;
        this.mediaTypes = MediaType.asMediaTypes(encoder.getEncodableMimeTypes());
        this.defaultMediaType = EncoderHttpMessageWriter.initDefaultMediaType(this.mediaTypes);
    }

    private static void initLogger(Encoder<?> encoder) {
        if (encoder instanceof AbstractEncoder && encoder.getClass().getName().startsWith("infra.core.codec")) {
            Logger logger = HttpLogging.forLog(((AbstractEncoder)encoder).getLogger());
            ((AbstractEncoder)encoder).setLogger(logger);
        }
    }

    @Nullable
    private static MediaType initDefaultMediaType(List<MediaType> mediaTypes) {
        return mediaTypes.stream().filter(MimeType::isConcrete).findFirst().orElse(null);
    }

    public Encoder<T> getEncoder() {
        return this.encoder;
    }

    @Override
    public List<MediaType> getWritableMediaTypes() {
        return this.mediaTypes;
    }

    @Override
    public List<MediaType> getWritableMediaTypes(ResolvableType elementType) {
        return MediaType.asMediaTypes(this.getEncoder().getEncodableMimeTypes(elementType));
    }

    @Override
    public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
        return this.encoder.canEncode(elementType, (MimeType)mediaType);
    }

    @Override
    public Mono<Void> write(Publisher<? extends T> inputStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage message, Map<String, Object> hints) {
        MediaType contentType = this.updateContentType(message, mediaType);
        Flux body = this.encoder.encode(inputStream, message.bufferFactory(), elementType, (MimeType)contentType, hints);
        if (inputStream instanceof Mono) {
            return body.singleOrEmpty().switchIfEmpty(Mono.defer(() -> {
                message.getHeaders().remove("Content-Type");
                message.getHeaders().setContentLength(0L);
                return message.setComplete().then(Mono.empty());
            })).flatMap(buffer -> {
                Hints.touchDataBuffer((DataBuffer)buffer, (Map)hints, (Logger)logger);
                message.getHeaders().setContentLength(buffer.readableByteCount());
                return message.writeWith((Publisher<? extends DataBuffer>)Mono.just((Object)buffer).doOnDiscard(DataBuffer.class, DataBufferUtils::release));
            }).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
        }
        if (this.isStreamingMediaType(contentType)) {
            return message.writeAndFlushWith((Publisher<? extends Publisher<? extends DataBuffer>>)body.map(buffer -> {
                Hints.touchDataBuffer((DataBuffer)buffer, (Map)hints, (Logger)logger);
                return Mono.just((Object)buffer).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
            }));
        }
        if (logger.isDebugEnabled()) {
            body = body.doOnNext(buffer -> Hints.touchDataBuffer((DataBuffer)buffer, (Map)hints, (Logger)logger));
        }
        return message.writeWith((Publisher<? extends DataBuffer>)body);
    }

    @Nullable
    private MediaType updateContentType(ReactiveHttpOutputMessage message, @Nullable MediaType mediaType) {
        MediaType result = message.getHeaders().getContentType();
        if (result != null) {
            return result;
        }
        MediaType fallback = this.defaultMediaType;
        MediaType mediaType2 = result = EncoderHttpMessageWriter.useFallback(mediaType, fallback) ? fallback : mediaType;
        if (result != null) {
            result = EncoderHttpMessageWriter.addDefaultCharset(result, fallback);
            message.getHeaders().setContentType(result);
        }
        return result;
    }

    private static boolean useFallback(@Nullable MediaType main, @Nullable MediaType fallback) {
        return main == null || !main.isConcrete() || main.equals(MediaType.APPLICATION_OCTET_STREAM) && fallback != null;
    }

    private static MediaType addDefaultCharset(MediaType main, @Nullable MediaType defaultType) {
        if (main.getCharset() == null && defaultType != null && defaultType.getCharset() != null) {
            return main.withCharset(defaultType.getCharset());
        }
        return main;
    }

    private boolean isStreamingMediaType(@Nullable MediaType mediaType) {
        if (mediaType == null || !(this.encoder instanceof HttpMessageEncoder)) {
            return false;
        }
        for (MediaType streamingMediaType : ((HttpMessageEncoder)this.encoder).getStreamingMediaTypes()) {
            if (!mediaType.isCompatibleWith(streamingMediaType) || !this.matchParameters(mediaType, streamingMediaType)) continue;
            return true;
        }
        return false;
    }

    private boolean matchParameters(MediaType streamingMediaType, MediaType mediaType) {
        for (String name : streamingMediaType.getParameters().keySet()) {
            String s1 = streamingMediaType.getParameter(name);
            String s2 = mediaType.getParameter(name);
            if (!StringUtils.hasText((String)s1) || !StringUtils.hasText((String)s2) || s1.equalsIgnoreCase(s2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Mono<Void> write(Publisher<? extends T> inputStream, ResolvableType actualType, ResolvableType elementType, @Nullable MediaType mediaType, ServerHttpRequest request, ServerHttpResponse response, Map<String, Object> hints) {
        Map allHints = Hints.merge(hints, this.getWriteHints(actualType, elementType, mediaType, request, response));
        return this.write(inputStream, elementType, mediaType, response, allHints);
    }

    protected Map<String, Object> getWriteHints(ResolvableType streamType, ResolvableType elementType, @Nullable MediaType mediaType, ServerHttpRequest request, ServerHttpResponse response) {
        Encoder<T> encoder = this.encoder;
        if (encoder instanceof HttpMessageEncoder) {
            HttpMessageEncoder encoder2 = (HttpMessageEncoder)encoder;
            return encoder2.getEncodeHints(streamType, elementType, mediaType, request, response);
        }
        return Hints.none();
    }
}

