/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec;

import infra.core.ResolvableType;
import infra.core.codec.AbstractDecoder;
import infra.core.codec.Decoder;
import infra.core.codec.Hints;
import infra.http.HttpLogging;
import infra.http.HttpMessage;
import infra.http.MediaType;
import infra.http.ReactiveHttpInputMessage;
import infra.http.codec.HttpMessageDecoder;
import infra.http.codec.HttpMessageReader;
import infra.http.server.reactive.ServerHttpRequest;
import infra.http.server.reactive.ServerHttpResponse;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.util.MimeType;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DecoderHttpMessageReader<T>
implements HttpMessageReader<T> {
    private final Decoder<T> decoder;
    private final List<MediaType> mediaTypes;

    public DecoderHttpMessageReader(Decoder<T> decoder) {
        Assert.notNull(decoder, (String)"Decoder is required");
        DecoderHttpMessageReader.initLogger(decoder);
        this.decoder = decoder;
        this.mediaTypes = MediaType.asMediaTypes(decoder.getDecodableMimeTypes());
    }

    private static void initLogger(Decoder<?> decoder) {
        if (decoder instanceof AbstractDecoder && decoder.getClass().getName().startsWith("infra.core.codec")) {
            Logger logger = HttpLogging.forLog(((AbstractDecoder)decoder).getLogger());
            ((AbstractDecoder)decoder).setLogger(logger);
        }
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return this.mediaTypes;
    }

    @Override
    public List<MediaType> getReadableMediaTypes(ResolvableType elementType) {
        return MediaType.asMediaTypes(this.decoder.getDecodableMimeTypes(elementType));
    }

    @Override
    public boolean canRead(ResolvableType elementType, @Nullable MediaType mediaType) {
        return this.decoder.canDecode(elementType, (MimeType)mediaType);
    }

    @Override
    public Flux<T> read(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        MediaType contentType = this.getContentType(message);
        Map allHints = Hints.merge(hints, this.getReadHints(elementType, message));
        return this.decoder.decode(message.getBody(), elementType, (MimeType)contentType, allHints);
    }

    @Override
    public Mono<T> readMono(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        MediaType contentType = this.getContentType(message);
        Map allHints = Hints.merge(hints, this.getReadHints(elementType, message));
        return this.decoder.decodeToMono(message.getBody(), elementType, (MimeType)contentType, allHints);
    }

    @Nullable
    protected MediaType getContentType(HttpMessage inputMessage) {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        return contentType != null ? contentType : MediaType.APPLICATION_OCTET_STREAM;
    }

    protected Map<String, Object> getReadHints(ResolvableType elementType, ReactiveHttpInputMessage message) {
        return Hints.none();
    }

    @Override
    public Flux<T> read(ResolvableType actualType, ResolvableType elementType, ServerHttpRequest request, ServerHttpResponse response, Map<String, Object> hints) {
        Map allHints = Hints.merge(hints, this.getReadHints(actualType, elementType, request, response));
        return this.read(elementType, request, allHints);
    }

    @Override
    public Mono<T> readMono(ResolvableType actualType, ResolvableType elementType, ServerHttpRequest request, ServerHttpResponse response, Map<String, Object> hints) {
        Map allHints = Hints.merge(hints, this.getReadHints(actualType, elementType, request, response));
        return this.readMono(elementType, request, allHints);
    }

    protected Map<String, Object> getReadHints(ResolvableType actualType, ResolvableType elementType, ServerHttpRequest request, ServerHttpResponse response) {
        Decoder<T> decoder = this.decoder;
        if (decoder instanceof HttpMessageDecoder) {
            HttpMessageDecoder decoder2 = (HttpMessageDecoder)decoder;
            return decoder2.getDecodeHints(actualType, elementType, request, response);
        }
        return Hints.none();
    }
}

