/*
 * Decompiled with CFR 0.152.
 */
package infra.http.codec;

import infra.beans.BeanUtils;
import infra.core.io.ClassPathResource;
import infra.core.io.PropertiesUtils;
import infra.core.io.Resource;
import infra.http.codec.CodecConfigurer;
import infra.util.ClassUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

final class CodecConfigurerFactory {
    private static final String DEFAULT_CONFIGURERS_PATH = "CodecConfigurer.properties";
    private static final HashMap<Class<?>, Class<?>> defaultCodecConfigurers = new HashMap(4);

    private CodecConfigurerFactory() {
    }

    public static <T extends CodecConfigurer> T create(Class<T> ifc) {
        Class<?> impl = defaultCodecConfigurers.get(ifc);
        if (impl == null) {
            throw new IllegalStateException("No default codec configurer found for " + ifc);
        }
        return (T)((CodecConfigurer)BeanUtils.newInstance(impl));
    }

    static {
        try {
            Properties props = PropertiesUtils.loadProperties((Resource)new ClassPathResource(DEFAULT_CONFIGURERS_PATH, CodecConfigurerFactory.class));
            for (String ifcName : props.stringPropertyNames()) {
                String implName = props.getProperty(ifcName);
                Class ifc = ClassUtils.forName((String)ifcName, (ClassLoader)CodecConfigurerFactory.class.getClassLoader());
                Class impl = ClassUtils.forName((String)implName, (ClassLoader)CodecConfigurerFactory.class.getClassLoader());
                defaultCodecConfigurers.put(ifc, impl);
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

