/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.support;

import infra.core.annotation.AnnotationAwareOrderComparator;
import infra.http.client.ClientHttpRequestFactory;
import infra.http.client.ClientHttpRequestInterceptor;
import infra.http.client.InterceptingClientHttpRequestFactory;
import infra.http.client.support.HttpAccessor;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class InterceptingHttpAccessor
extends HttpAccessor {
    private final ArrayList<ClientHttpRequestInterceptor> interceptors = new ArrayList();
    @Nullable
    private volatile ClientHttpRequestFactory interceptingRequestFactory;

    public void setInterceptors(List<ClientHttpRequestInterceptor> interceptors) {
        Assert.noNullElements(interceptors, (String)"'interceptors' must not contain null elements");
        if (this.interceptors != interceptors) {
            this.interceptors.clear();
            this.interceptors.addAll(interceptors);
            this.interceptors.trimToSize();
            AnnotationAwareOrderComparator.sort(this.interceptors);
        }
    }

    public void setInterceptors(ClientHttpRequestInterceptor ... interceptors) {
        Assert.noNullElements((Object[])interceptors, (String)"'interceptors' must not contain null elements");
        this.interceptors.clear();
        CollectionUtils.addAll(this.interceptors, (Object[])interceptors);
        this.interceptors.trimToSize();
        AnnotationAwareOrderComparator.sort(this.interceptors);
    }

    public List<ClientHttpRequestInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        super.setRequestFactory(requestFactory);
        this.interceptingRequestFactory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientHttpRequestFactory getRequestFactory() {
        if (!this.interceptors.isEmpty()) {
            ClientHttpRequestFactory factory = this.interceptingRequestFactory;
            if (factory == null) {
                InterceptingHttpAccessor interceptingHttpAccessor = this;
                synchronized (interceptingHttpAccessor) {
                    factory = this.interceptingRequestFactory;
                    if (factory == null) {
                        this.interceptingRequestFactory = factory = new InterceptingClientHttpRequestFactory(super.getRequestFactory(), this.interceptors);
                    }
                }
            }
            return factory;
        }
        return super.getRequestFactory();
    }
}

