/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.support;

import infra.core.AttributeAccessor;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpRequest;
import infra.lang.Assert;
import infra.lang.Nullable;
import java.net.URI;
import java.util.Map;
import java.util.function.Function;

public class HttpRequestDecorator
implements HttpRequest {
    private final HttpRequest request;

    public HttpRequestDecorator(HttpRequest request) {
        Assert.notNull((Object)request, (String)"HttpRequest is required");
        this.request = request;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getMethodValue() {
        return this.request.getMethodValue();
    }

    @Override
    public URI getURI() {
        return this.request.getURI();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.request.getHeaders();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.request.getAttributes();
    }

    public void setAttributes(@Nullable Map<String, Object> attributes) {
        this.request.setAttributes(attributes);
    }

    public Iterable<String> attributeNames() {
        return this.request.attributeNames();
    }

    public void clearAttributes() {
        this.request.clearAttributes();
    }

    public <T> T computeAttribute(String name, Function<String, T> computeFunction) {
        return (T)this.request.computeAttribute(name, computeFunction);
    }

    public void copyFrom(AttributeAccessor source) {
        this.request.copyFrom(source);
    }

    @Nullable
    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public String[] getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public boolean hasAttribute(String name) {
        return this.request.hasAttribute(name);
    }

    public boolean hasAttributes() {
        return this.request.hasAttributes();
    }

    @Nullable
    public Object removeAttribute(String name) {
        return this.request.removeAttribute(name);
    }

    public void setAttribute(String name, @Nullable Object value) {
        this.request.setAttribute(name, value);
    }
}

