/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.support;

import infra.core.annotation.AnnotationAwareOrderComparator;
import infra.http.HttpMethod;
import infra.http.client.ClientHttpRequest;
import infra.http.client.ClientHttpRequestFactory;
import infra.http.client.ClientHttpRequestInitializer;
import infra.http.client.JdkClientHttpRequestFactory;
import infra.lang.Assert;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public abstract class HttpAccessor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ClientHttpRequestFactory requestFactory = new JdkClientHttpRequestFactory();
    private final ArrayList<ClientHttpRequestInitializer> httpRequestInitializers = new ArrayList();

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        Assert.notNull((Object)requestFactory, (String)"ClientHttpRequestFactory is required");
        this.requestFactory = requestFactory;
    }

    public ClientHttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public void setHttpRequestInitializers(List<ClientHttpRequestInitializer> requestInitializers) {
        if (this.httpRequestInitializers != requestInitializers) {
            this.httpRequestInitializers.clear();
            this.httpRequestInitializers.addAll(requestInitializers);
            AnnotationAwareOrderComparator.sort(this.httpRequestInitializers);
            this.httpRequestInitializers.trimToSize();
        }
    }

    public List<ClientHttpRequestInitializer> getHttpRequestInitializers() {
        return this.httpRequestInitializers;
    }

    protected ClientHttpRequest createRequest(URI url, HttpMethod method) throws IOException {
        ClientHttpRequest request = this.getRequestFactory().createRequest(url, method);
        List<ClientHttpRequestInitializer> requestInitializers = this.getHttpRequestInitializers();
        if (!requestInitializers.isEmpty()) {
            for (ClientHttpRequestInitializer initializer : requestInitializers) {
                initializer.initialize(request);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("HTTP {} {}", (Object)method.name(), (Object)url);
        }
        return request;
    }
}

