/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.support;

import infra.http.HttpHeaders;
import infra.http.HttpRequest;
import infra.http.client.ClientHttpRequestExecution;
import infra.http.client.ClientHttpRequestInterceptor;
import infra.http.client.ClientHttpResponse;
import infra.lang.Nullable;
import java.io.IOException;
import java.nio.charset.Charset;

public class BasicAuthenticationInterceptor
implements ClientHttpRequestInterceptor {
    private final String encodedCredentials;

    public BasicAuthenticationInterceptor(String username, String password) {
        this(username, password, null);
    }

    public BasicAuthenticationInterceptor(String username, String password, @Nullable Charset charset) {
        this.encodedCredentials = HttpHeaders.encodeBasicAuth(username, password, charset);
    }

    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpHeaders headers = request.getHeaders();
        if (!headers.containsKey("Authorization")) {
            headers.setBasicAuth(this.encodedCredentials);
        }
        return execution.execute(request, body);
    }
}

