/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.reactive;

import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.Netty5DataBufferFactory;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatusCode;
import infra.http.ResponseCookie;
import infra.http.client.reactive.ClientHttpResponse;
import infra.http.support.Netty5HttpHeaders;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.util.ObjectUtils;
import io.netty5.handler.codec.http.headers.DefaultHttpSetCookie;
import io.netty5.handler.codec.http.headers.HttpSetCookie;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.Flux;
import reactor.netty5.ChannelOperationsId;
import reactor.netty5.Connection;
import reactor.netty5.NettyInbound;
import reactor.netty5.http.client.HttpClientResponse;

class ReactorNetty2ClientHttpResponse
implements ClientHttpResponse {
    private static final Logger logger = LoggerFactory.getLogger(ReactorNetty2ClientHttpResponse.class);
    private final HttpClientResponse response;
    private final HttpHeaders headers;
    private final NettyInbound inbound;
    private final Netty5DataBufferFactory bufferFactory;
    private final AtomicInteger state = new AtomicInteger();

    public ReactorNetty2ClientHttpResponse(HttpClientResponse response, Connection connection) {
        this.response = response;
        this.inbound = connection.inbound();
        this.headers = new Netty5HttpHeaders(response.responseHeaders()).asReadOnly();
        this.bufferFactory = new Netty5DataBufferFactory(connection.outbound().alloc());
    }

    @Override
    public String getId() {
        String id = null;
        HttpClientResponse httpClientResponse = this.response;
        if (httpClientResponse instanceof ChannelOperationsId) {
            ChannelOperationsId operationsId = (ChannelOperationsId)httpClientResponse;
            String string = id = logger.isDebugEnabled() ? operationsId.asLongText() : operationsId.asShortText();
        }
        if (id == null && (httpClientResponse = this.response) instanceof Connection) {
            Connection connection = (Connection)httpClientResponse;
            id = connection.channel().id().asShortText();
        }
        return id != null ? id : ObjectUtils.getIdentityHexString((Object)this);
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.inbound.receive().doOnSubscribe(s -> {
            if (this.state.compareAndSet(0, 1)) {
                return;
            }
            if (this.state.get() == 2) {
                throw new IllegalStateException("The client response body has been released already due to cancellation.");
            }
        }).map(buffer -> this.bufferFactory.wrap(buffer.split()));
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf(this.response.status().code());
    }

    @Override
    public int getRawStatusCode() {
        return this.response.status().code();
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        this.response.cookies().values().stream().flatMap(Collection::stream).forEach(arg_0 -> ReactorNetty2ClientHttpResponse.lambda$getCookies$2((MultiValueMap)result, arg_0));
        return result.asReadOnly();
    }

    @Nullable
    private static String getSameSite(HttpSetCookie cookie) {
        DefaultHttpSetCookie defaultCookie;
        if (cookie instanceof DefaultHttpSetCookie && (defaultCookie = (DefaultHttpSetCookie)cookie).sameSite() != null) {
            return defaultCookie.sameSite().name();
        }
        return null;
    }

    void releaseAfterCancel(HttpMethod method) {
        if (this.mayHaveBody(method) && this.state.compareAndSet(0, 2)) {
            if (logger.isDebugEnabled()) {
                logger.debug("[{}]Releasing body, not yet subscribed.", (Object)this.getId());
            }
            this.inbound.receive().doOnNext(buffer -> {}).subscribe(buffer -> {}, ex -> {});
        }
    }

    private boolean mayHaveBody(HttpMethod method) {
        int code = this.getStatusCode().value();
        return (code < 100 || code >= 200) && code != 204 && code != 205 && !method.equals((Object)HttpMethod.HEAD) && this.getHeaders().getContentLength() != 0L;
    }

    public String toString() {
        return "ReactorNetty2ClientHttpResponse{request=[" + this.response.method().name() + " " + this.response.uri() + "],status=" + this.getStatusCode() + "}";
    }

    private static /* synthetic */ void lambda$getCookies$2(MultiValueMap result, HttpSetCookie cookie) {
        result.add((Object)cookie.name().toString(), (Object)ResponseCookie.fromClientResponse(cookie.name().toString(), cookie.value().toString()).domain(cookie.domain() != null ? cookie.domain().toString() : null).path(cookie.path() != null ? cookie.path().toString() : null).maxAge(cookie.maxAge() != null ? cookie.maxAge() : -1L).secure(cookie.isSecure()).httpOnly(cookie.isHttpOnly()).sameSite(ReactorNetty2ClientHttpResponse.getSameSite(cookie)).build());
    }
}

