/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.reactive;

import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.NettyDataBufferFactory;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.ResponseCookie;
import infra.http.client.reactive.ClientHttpResponse;
import infra.http.support.Netty4HttpHeaders;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.util.ObjectUtils;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.Flux;
import reactor.netty.ChannelOperationsId;
import reactor.netty.Connection;
import reactor.netty.NettyInbound;
import reactor.netty.http.client.HttpClientResponse;

class ReactorClientHttpResponse
implements ClientHttpResponse {
    private static final Logger logger = LoggerFactory.getLogger(ReactorClientHttpResponse.class);
    private final HttpHeaders headers;
    private final NettyInbound inbound;
    private final HttpClientResponse response;
    private final NettyDataBufferFactory bufferFactory;
    private final AtomicInteger state = new AtomicInteger();

    public ReactorClientHttpResponse(HttpClientResponse response, Connection connection) {
        this.response = response;
        this.inbound = connection.inbound();
        this.headers = new Netty4HttpHeaders(response.responseHeaders()).asReadOnly();
        this.bufferFactory = new NettyDataBufferFactory(connection.outbound().alloc());
    }

    @Override
    public String getId() {
        String id = null;
        HttpClientResponse httpClientResponse = this.response;
        if (httpClientResponse instanceof ChannelOperationsId) {
            ChannelOperationsId operationsId = (ChannelOperationsId)httpClientResponse;
            String string = id = logger.isDebugEnabled() ? operationsId.asLongText() : operationsId.asShortText();
        }
        if (id == null && (httpClientResponse = this.response) instanceof Connection) {
            Connection connection = (Connection)httpClientResponse;
            id = connection.channel().id().asShortText();
        }
        return id != null ? id : ObjectUtils.getIdentityHexString((Object)this);
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.inbound.receive().doOnSubscribe(s -> {
            if (this.state.compareAndSet(0, 1)) {
                return;
            }
            if (this.state.get() == 2) {
                throw new IllegalStateException("The client response body has been released already due to cancellation.");
            }
        }).map(byteBuf -> {
            byteBuf.retain();
            return this.bufferFactory.wrap(byteBuf);
        });
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public int getRawStatusCode() {
        return this.response.status().code();
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        LinkedMultiValueMap result = MultiValueMap.forLinkedHashMap();
        for (Map.Entry entry : this.response.cookies().entrySet()) {
            Set cookies = (Set)entry.getValue();
            for (Cookie cookie : cookies) {
                result.add((Object)cookie.name(), (Object)ResponseCookie.fromClientResponse(cookie.name(), cookie.value()).domain(cookie.domain()).path(cookie.path()).maxAge(cookie.maxAge()).secure(cookie.isSecure()).httpOnly(cookie.isHttpOnly()).sameSite(ReactorClientHttpResponse.getSameSite(cookie)).build());
            }
        }
        return result.asReadOnly();
    }

    @Nullable
    private static String getSameSite(Cookie cookie) {
        DefaultCookie defaultCookie;
        if (cookie instanceof DefaultCookie && (defaultCookie = (DefaultCookie)cookie).sameSite() != null) {
            return defaultCookie.sameSite().name();
        }
        return null;
    }

    void releaseAfterCancel(HttpMethod method) {
        if (this.mayHaveBody(method) && this.state.compareAndSet(0, 2)) {
            if (logger.isDebugEnabled()) {
                logger.debug("[{}] Releasing body, not yet subscribed.", (Object)this.getId());
            }
            this.inbound.receive().doOnNext(byteBuf -> {}).subscribe(byteBuf -> {}, ex -> {});
        }
    }

    private boolean mayHaveBody(HttpMethod method) {
        int code = this.getRawStatusCode();
        return (code < 100 || code >= 200) && code != 204 && code != 205 && !method.equals((Object)HttpMethod.HEAD) && this.getHeaders().getContentLength() != 0L;
    }

    public String toString() {
        return "ReactorClientHttpResponse{request=[%s %s],status=%d}".formatted(this.response.method().name(), this.response.uri(), this.getRawStatusCode());
    }
}

