/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.reactive;

import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.core.io.buffer.NettyDataBufferFactory;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.ZeroCopyHttpOutputMessage;
import infra.http.client.reactive.AbstractClientHttpRequest;
import infra.http.client.reactive.ReactorClientHttpConnector;
import infra.http.support.Netty4HttpHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.NettyOutbound;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClientRequest;

class ReactorClientHttpRequest
extends AbstractClientHttpRequest
implements ZeroCopyHttpOutputMessage {
    private final URI uri;
    private final HttpMethod httpMethod;
    private final NettyOutbound outbound;
    private final HttpClientRequest request;
    private final NettyDataBufferFactory bufferFactory;

    public ReactorClientHttpRequest(HttpMethod method, URI uri, HttpClientRequest request, NettyOutbound outbound) {
        this.httpMethod = method;
        this.uri = uri;
        this.request = request;
        this.outbound = outbound;
        this.bufferFactory = new NettyDataBufferFactory(outbound.alloc());
    }

    @Override
    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.request;
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        return this.doCommit(() -> {
            if (body instanceof Mono) {
                Mono byteBufMono = Mono.from((Publisher)body).map(NettyDataBufferFactory::toByteBuf);
                return this.outbound.send((Publisher)byteBufMono).then();
            }
            Flux byteBufFlux = Flux.from((Publisher)body).map(NettyDataBufferFactory::toByteBuf);
            return this.outbound.send((Publisher)byteBufFlux).then();
        });
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        Flux byteBufs = Flux.from(body).map(ReactorClientHttpRequest::toByteBufs);
        return this.doCommit(() -> this.lambda$writeAndFlushWith$1((Publisher)byteBufs));
    }

    private static Publisher<ByteBuf> toByteBufs(Publisher<? extends DataBuffer> dataBuffers) {
        return Flux.from(dataBuffers).map(NettyDataBufferFactory::toByteBuf);
    }

    @Override
    public Mono<Void> writeWith(Path file, long position, long count) {
        return this.doCommit(() -> this.outbound.sendFile(file, position, count).then());
    }

    @Override
    public Mono<Void> setComplete() {
        return this.doCommit(() -> ((NettyOutbound)this.outbound).then());
    }

    @Override
    protected void applyHeaders() {
        for (Map.Entry entry : this.getHeaders().entrySet()) {
            this.request.requestHeaders().set((String)entry.getKey(), (Iterable)entry.getValue());
        }
    }

    @Override
    protected void applyCookies() {
        for (List values : this.getCookies().values()) {
            for (HttpCookie value : values) {
                DefaultCookie cookie = new DefaultCookie(value.getName(), value.getValue());
                this.request.addCookie((Cookie)cookie);
            }
        }
    }

    @Override
    protected void applyAttributes() {
        if (!this.getAttributes().isEmpty()) {
            ((ChannelOperations)this.request).channel().attr(ReactorClientHttpConnector.ATTRIBUTES_KEY).set((Object)this.getAttributes());
        }
    }

    @Override
    protected HttpHeaders initReadOnlyHeaders() {
        return new Netty4HttpHeaders(this.request.requestHeaders()).asReadOnly();
    }

    private /* synthetic */ Publisher lambda$writeAndFlushWith$1(Publisher byteBufs) {
        return this.outbound.sendGroups(byteBufs).then();
    }
}

