/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.reactive;

import infra.beans.factory.DisposableBean;
import infra.beans.factory.InitializingBean;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.scheduling.concurrent.CustomizableThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class JdkHttpClientResourceFactory
implements InitializingBean,
DisposableBean {
    @Nullable
    private Executor executor;
    private String threadPrefix = "jdk-http";

    public void setExecutor(@Nullable Executor executor) {
        this.executor = executor;
    }

    @Nullable
    public Executor getExecutor() {
        return this.executor;
    }

    public void setThreadPrefix(String threadPrefix) {
        Assert.notNull((Object)threadPrefix, (String)"Thread prefix is required");
        this.threadPrefix = threadPrefix;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.executor == null) {
            String name = this.threadPrefix + "@" + Integer.toHexString(this.hashCode());
            this.executor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory(name));
        }
    }

    public void destroy() throws Exception {
        Executor executor = this.executor;
        if (executor instanceof ExecutorService) {
            ExecutorService executorService = (ExecutorService)executor;
            executorService.shutdown();
        }
    }
}

