/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.reactive;

import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.core.io.buffer.DataBufferUtils;
import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.http.ResponseCookie;
import infra.http.client.reactive.AbstractClientHttpResponse;
import infra.lang.Nullable;
import infra.util.LinkedCaseInsensitiveMap;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.util.MultiValueMapAdapter;
import java.net.HttpCookie;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.adapter.JdkFlowAdapter;
import reactor.core.publisher.Flux;

class JdkClientHttpResponse
extends AbstractClientHttpResponse {
    private static final Pattern SAME_SITE_PATTERN = Pattern.compile("(?i).*SameSite=(Strict|Lax|None).*");

    public JdkClientHttpResponse(HttpResponse<Flow.Publisher<List<ByteBuffer>>> response, DataBufferFactory bufferFactory) {
        super(HttpStatusCode.valueOf(response.statusCode()), JdkClientHttpResponse.adaptHeaders(response), JdkClientHttpResponse.adaptCookies(response), JdkClientHttpResponse.adaptBody(response, bufferFactory));
    }

    private static HttpHeaders adaptHeaders(HttpResponse<Flow.Publisher<List<ByteBuffer>>> response) {
        Map<String, List<String>> rawHeaders = response.headers().map();
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap(rawHeaders.size(), Locale.ROOT);
        MultiValueMapAdapter multiValueMap = MultiValueMap.forAdaption((Map)map);
        multiValueMap.putAll(rawHeaders);
        return HttpHeaders.readOnlyHttpHeaders((MultiValueMap<String, String>)multiValueMap);
    }

    private static MultiValueMap<String, ResponseCookie> adaptCookies(HttpResponse<Flow.Publisher<List<ByteBuffer>>> response) {
        return (MultiValueMap)response.headers().allValues("Set-Cookie").stream().flatMap(header -> {
            Matcher matcher = SAME_SITE_PATTERN.matcher((CharSequence)header);
            String sameSite = matcher.matches() ? matcher.group(1) : null;
            return HttpCookie.parse(header).stream().map(cookie -> JdkClientHttpResponse.toResponseCookie(cookie, sameSite));
        }).collect(LinkedMultiValueMap::new, (cookies, cookie) -> cookies.add((Object)cookie.getName(), cookie), MultiValueMap::addAll);
    }

    private static ResponseCookie toResponseCookie(HttpCookie cookie, @Nullable String sameSite) {
        return ResponseCookie.from(cookie.getName(), cookie.getValue()).domain(cookie.getDomain()).httpOnly(cookie.isHttpOnly()).maxAge(cookie.getMaxAge()).path(cookie.getPath()).secure(cookie.getSecure()).sameSite(sameSite).build();
    }

    private static Flux<DataBuffer> adaptBody(HttpResponse<Flow.Publisher<List<ByteBuffer>>> response, DataBufferFactory bufferFactory) {
        return JdkFlowAdapter.flowPublisherToFlux(response.body()).flatMapIterable(Function.identity()).map(arg_0 -> ((DataBufferFactory)bufferFactory).wrap(arg_0)).doOnDiscard(DataBuffer.class, DataBufferUtils::release).cache(0);
    }
}

