/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.reactive;

import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.http.HttpCookie;
import infra.http.HttpMethod;
import infra.http.client.reactive.AbstractClientHttpRequest;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import java.net.URI;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.adapter.JdkFlowAdapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class JdkClientHttpRequest
extends AbstractClientHttpRequest {
    private final HttpMethod method;
    private final URI uri;
    private final DataBufferFactory bufferFactory;
    private final HttpRequest.Builder builder;

    public JdkClientHttpRequest(HttpMethod httpMethod, URI uri, DataBufferFactory bufferFactory, @Nullable Duration readTimeout) {
        Assert.notNull((Object)((Object)httpMethod), (String)"HttpMethod is required");
        Assert.notNull((Object)uri, (String)"URI is required");
        Assert.notNull((Object)bufferFactory, (String)"DataBufferFactory is required");
        this.method = httpMethod;
        this.uri = uri;
        this.bufferFactory = bufferFactory;
        this.builder = HttpRequest.newBuilder(uri);
        if (readTimeout != null) {
            this.builder.timeout(readTimeout);
        }
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.builder.build();
    }

    @Override
    protected void applyHeaders() {
        for (Map.Entry entry : this.getHeaders().entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("Content-Length")) continue;
            for (String value : (List)entry.getValue()) {
                this.builder.header((String)entry.getKey(), value);
            }
        }
        if (!this.getHeaders().containsKey("Accept")) {
            this.builder.header("Accept", "*/*");
        }
    }

    @Override
    protected void applyCookies() {
        MultiValueMap<String, HttpCookie> cookies = this.getCookies();
        if (cookies.isEmpty()) {
            return;
        }
        this.builder.header("Cookie", cookies.values().stream().flatMap(Collection::stream).map(HttpCookie::toString).collect(Collectors.joining(";")));
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        return this.doCommit(() -> {
            this.builder.method(this.method.name(), this.toBodyPublisher(body));
            return Mono.empty();
        });
    }

    private HttpRequest.BodyPublisher toBodyPublisher(Publisher<? extends DataBuffer> body) {
        Mono byteBufferBody = body instanceof Mono ? Mono.from(body).map(this::toByteBuffer) : Flux.from(body).map(this::toByteBuffer);
        Flow.Publisher bodyFlow = JdkFlowAdapter.publisherToFlowPublisher((Publisher)byteBufferBody);
        return this.getHeaders().getContentLength() > 0L ? HttpRequest.BodyPublishers.fromPublisher(bodyFlow, this.getHeaders().getContentLength()) : HttpRequest.BodyPublishers.fromPublisher(bodyFlow);
    }

    private ByteBuffer toByteBuffer(DataBuffer dataBuffer) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(dataBuffer.readableByteCount());
        dataBuffer.toByteBuffer(byteBuffer);
        return byteBuffer;
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return this.writeWith((Publisher<? extends DataBuffer>)Flux.from(body).flatMap(Function.identity()));
    }

    @Override
    public Mono<Void> setComplete() {
        return this.doCommit(() -> {
            this.builder.method(this.method.name(), HttpRequest.BodyPublishers.noBody());
            return Mono.empty();
        });
    }
}

