/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.reactive;

import infra.core.io.buffer.DataBufferFactory;
import infra.core.io.buffer.DefaultDataBufferFactory;
import infra.http.HttpMethod;
import infra.http.client.reactive.ClientHttpConnector;
import infra.http.client.reactive.ClientHttpRequest;
import infra.http.client.reactive.ClientHttpResponse;
import infra.http.client.reactive.JdkClientHttpRequest;
import infra.http.client.reactive.JdkClientHttpResponse;
import infra.http.client.reactive.JdkHttpClientResourceFactory;
import infra.lang.Assert;
import infra.lang.Nullable;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class JdkClientHttpConnector
implements ClientHttpConnector {
    private final HttpClient httpClient;
    private DataBufferFactory bufferFactory = DefaultDataBufferFactory.sharedInstance;
    @Nullable
    private Duration readTimeout = null;

    public JdkClientHttpConnector() {
        this(HttpClient.newHttpClient());
    }

    public JdkClientHttpConnector(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public JdkClientHttpConnector(HttpClient.Builder clientBuilder, @Nullable JdkHttpClientResourceFactory resourceFactory) {
        if (resourceFactory != null) {
            Executor executor = resourceFactory.getExecutor();
            clientBuilder.executor(executor);
        }
        this.httpClient = clientBuilder.build();
    }

    public void setBufferFactory(DataBufferFactory bufferFactory) {
        Assert.notNull((Object)bufferFactory, (String)"DataBufferFactory is required");
        this.bufferFactory = bufferFactory;
    }

    public void setReadTimeout(Duration readTimeout) {
        Assert.notNull((Object)readTimeout, (String)"readTimeout is required");
        this.readTimeout = readTimeout;
    }

    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        JdkClientHttpRequest jdkClientHttpRequest = new JdkClientHttpRequest(method, uri, this.bufferFactory, this.readTimeout);
        return requestCallback.apply(jdkClientHttpRequest).then(Mono.defer(() -> {
            HttpRequest httpRequest = (HttpRequest)jdkClientHttpRequest.getNativeRequest();
            CompletableFuture<HttpResponse<Flow.Publisher<List<ByteBuffer>>>> future = this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofPublisher());
            return Mono.fromCompletionStage(future).map(response -> new JdkClientHttpResponse((HttpResponse<Flow.Publisher<List<ByteBuffer>>>)response, this.bufferFactory));
        }));
    }
}

