/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.reactive;

import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.http.HttpStatusCode;
import infra.http.ResponseCookie;
import infra.http.client.reactive.AbstractClientHttpResponse;
import infra.http.client.reactive.HttpComponentsHeaders;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Iterator;
import java.util.List;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.CookieSpec;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class HttpComponentsClientHttpResponse
extends AbstractClientHttpResponse {
    public HttpComponentsClientHttpResponse(DataBufferFactory dataBufferFactory, Message<HttpResponse, Publisher<ByteBuffer>> message, HttpClientContext context) {
        super(HttpStatusCode.valueOf(((HttpResponse)message.getHead()).getCode()), new HttpComponentsHeaders((HttpMessage)message.getHead()).asReadOnly(), HttpComponentsClientHttpResponse.adaptCookies((HttpResponse)message.getHead(), context), (Flux<DataBuffer>)Flux.from((Publisher)((Publisher)message.getBody())).map(arg_0 -> ((DataBufferFactory)dataBufferFactory).wrap(arg_0)));
    }

    private static MultiValueMap<String, ResponseCookie> adaptCookies(HttpResponse response, HttpClientContext context) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        CookieSpec cookieSpec = context.getCookieSpec();
        CookieOrigin cookieOrigin = context.getCookieOrigin();
        Iterator itr = response.headerIterator("Set-Cookie");
        while (itr.hasNext()) {
            Header header = (Header)itr.next();
            try {
                List cookies = cookieSpec.parse(header, cookieOrigin);
                for (Cookie cookie : cookies) {
                    try {
                        cookieSpec.validate(cookie, cookieOrigin);
                        result.add((Object)cookie.getName(), (Object)ResponseCookie.fromClientResponse(cookie.getName(), cookie.getValue()).domain(cookie.getDomain()).path(cookie.getPath()).maxAge(HttpComponentsClientHttpResponse.getMaxAgeSeconds(cookie)).secure(cookie.isSecure()).httpOnly(cookie.containsAttribute("httponly")).sameSite(cookie.getAttribute("samesite")).build());
                    }
                    catch (MalformedCookieException malformedCookieException) {}
                }
            }
            catch (MalformedCookieException malformedCookieException) {
            }
        }
        return result;
    }

    private static long getMaxAgeSeconds(Cookie cookie) {
        String expiresAttribute = cookie.getAttribute("expires");
        String maxAgeAttribute = cookie.getAttribute("max-age");
        if (maxAgeAttribute != null) {
            return Long.parseLong(maxAgeAttribute);
        }
        if (expiresAttribute != null) {
            try {
                ZonedDateTime expiresDate = ZonedDateTime.parse(expiresAttribute, DateTimeFormatter.RFC_1123_DATE_TIME);
                return Duration.between(ZonedDateTime.now(expiresDate.getZone()), expiresDate).toSeconds();
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return -1L;
    }
}

