/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.reactive;

import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.MediaType;
import infra.http.client.reactive.AbstractClientHttpRequest;
import infra.http.client.reactive.HttpComponentsHeaders;
import infra.lang.Nullable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.reactive.ReactiveEntityProducer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class HttpComponentsClientHttpRequest
extends AbstractClientHttpRequest {
    private final HttpRequest httpRequest;
    private final DataBufferFactory dataBufferFactory;
    private final HttpClientContext context;
    @Nullable
    private Flux<ByteBuffer> byteBufferFlux;
    private transient long contentLength = -1L;

    public HttpComponentsClientHttpRequest(HttpMethod method, URI uri, HttpClientContext context, DataBufferFactory dataBufferFactory) {
        this.context = context;
        this.httpRequest = new BasicHttpRequest(method.name(), uri);
        this.dataBufferFactory = dataBufferFactory;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.httpRequest.getMethod());
    }

    @Override
    public URI getURI() {
        try {
            return this.httpRequest.getUri();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid URI syntax: " + ex.getMessage());
        }
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.dataBufferFactory;
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.httpRequest;
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        return this.doCommit(() -> {
            this.byteBufferFlux = Flux.from((Publisher)body).map(dataBuffer -> {
                ByteBuffer byteBuffer = ByteBuffer.allocate(dataBuffer.readableByteCount());
                dataBuffer.toByteBuffer(byteBuffer);
                return byteBuffer;
            });
            return Mono.empty();
        });
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return this.writeWith((Publisher<? extends DataBuffer>)Flux.from(body).flatMap(Function.identity()));
    }

    @Override
    public Mono<Void> setComplete() {
        return this.doCommit();
    }

    @Override
    protected void applyHeaders() {
        HttpHeaders headers = this.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            if ("Content-Length".equals(key)) continue;
            for (String v : (List)entry.getValue()) {
                this.httpRequest.addHeader(key, (Object)v);
            }
        }
        if (!this.httpRequest.containsHeader("Accept")) {
            this.httpRequest.addHeader("Accept", (Object)"*/*");
        }
        this.contentLength = headers.getContentLength();
    }

    @Override
    protected void applyCookies() {
        if (!this.getCookies().isEmpty()) {
            this.httpRequest.setHeader("Cookie", (Object)this.serializeCookies());
        }
    }

    private String serializeCookies() {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (List cookies : this.getCookies().values()) {
            for (HttpCookie cookie : cookies) {
                if (!first) {
                    sb.append("; ");
                } else {
                    first = false;
                }
                sb.append(cookie.getName()).append("=").append(cookie.getValue());
            }
        }
        return sb.toString();
    }

    @Override
    protected void applyAttributes() {
        if (this.hasAttributes()) {
            this.getAttributes().forEach((key, value) -> {
                if (this.context.getAttribute(key) == null) {
                    this.context.setAttribute(key, value);
                }
            });
        }
    }

    @Override
    protected HttpHeaders initReadOnlyHeaders() {
        return new HttpComponentsHeaders((HttpMessage)this.httpRequest).asReadOnly();
    }

    public AsyncRequestProducer toRequestProducer() {
        ReactiveEntityProducer reactiveEntityProducer = null;
        if (this.byteBufferFlux != null) {
            HttpHeaders headers = this.getHeaders();
            String contentEncoding = headers.getFirst("Content-Encoding");
            ContentType contentType = null;
            MediaType mediaType = headers.getContentType();
            if (mediaType != null) {
                contentType = ContentType.create((String)"%s/%s".formatted(mediaType.getType(), mediaType.getSubtype()), (Charset)mediaType.getCharset());
            }
            reactiveEntityProducer = new ReactiveEntityProducer(this.byteBufferFlux, this.contentLength, contentType, contentEncoding);
        }
        return new BasicRequestProducer(this.httpRequest, reactiveEntityProducer);
    }
}

