/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.reactive;

import infra.core.AttributeAccessor;
import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.client.reactive.ClientHttpRequest;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ClientHttpRequestDecorator
implements ClientHttpRequest {
    private final ClientHttpRequest delegate;

    public ClientHttpRequestDecorator(ClientHttpRequest delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate is required");
        this.delegate = delegate;
    }

    public ClientHttpRequest getDelegate() {
        return this.delegate;
    }

    @Override
    public HttpMethod getMethod() {
        return this.delegate.getMethod();
    }

    @Override
    public URI getURI() {
        return this.delegate.getURI();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.delegate.getHeaders();
    }

    @Override
    public MultiValueMap<String, HttpCookie> getCookies() {
        return this.delegate.getCookies();
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.delegate.bufferFactory();
    }

    @Override
    public <T> T getNativeRequest() {
        return this.delegate.getNativeRequest();
    }

    @Override
    public void beforeCommit(Supplier<? extends Mono<Void>> action) {
        this.delegate.beforeCommit(action);
    }

    @Override
    public boolean isCommitted() {
        return this.delegate.isCommitted();
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        return this.delegate.writeWith(body);
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return this.delegate.writeAndFlushWith(body);
    }

    @Override
    public Mono<Void> setComplete() {
        return this.delegate.setComplete();
    }

    public void setAttributes(@Nullable Map<String, Object> attributes) {
        this.delegate.setAttributes(attributes);
    }

    public Iterable<String> attributeNames() {
        return this.delegate.attributeNames();
    }

    public void clearAttributes() {
        this.delegate.clearAttributes();
    }

    public <T> T computeAttribute(String name, Function<String, T> computeFunction) {
        return (T)this.delegate.computeAttribute(name, computeFunction);
    }

    public void copyFrom(AttributeAccessor source) {
        this.delegate.copyFrom(source);
    }

    @Nullable
    public Object getAttribute(String name) {
        return this.delegate.getAttribute(name);
    }

    public String[] getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public Map<String, Object> getAttributes() {
        return this.delegate.getAttributes();
    }

    public boolean hasAttribute(String name) {
        return this.delegate.hasAttribute(name);
    }

    public boolean hasAttributes() {
        return this.delegate.hasAttributes();
    }

    @Nullable
    public Object removeAttribute(String name) {
        return this.delegate.removeAttribute(name);
    }

    public void setAttribute(String name, @Nullable Object value) {
        this.delegate.setAttribute(name, value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [delegate=" + this.getDelegate() + "]";
    }
}

