/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.reactive;

import infra.core.io.buffer.DataBuffer;
import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.http.ResponseCookie;
import infra.http.client.reactive.ClientHttpResponse;
import infra.lang.Assert;
import infra.util.MultiValueMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;

public abstract class AbstractClientHttpResponse
implements ClientHttpResponse {
    private final HttpStatusCode statusCode;
    private final HttpHeaders headers;
    private final MultiValueMap<String, ResponseCookie> cookies;
    private final Flux<DataBuffer> body;

    protected AbstractClientHttpResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, ResponseCookie> cookies, Flux<DataBuffer> body) {
        Assert.notNull((Object)statusCode, (String)"StatusCode is required");
        Assert.notNull((Object)headers, (String)"Headers is required");
        Assert.notNull(body, (String)"Body is required");
        this.statusCode = statusCode;
        this.headers = headers;
        this.cookies = cookies;
        this.body = Flux.from(new SingleSubscriberPublisher<DataBuffer>((Publisher<DataBuffer>)body));
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    @Override
    public int getRawStatusCode() {
        return this.statusCode.value();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.cookies;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    private static final class SingleSubscriberPublisher<T>
    implements Publisher<T> {
        private static final Subscription NO_OP_SUBSCRIPTION = new Subscription(){

            public void request(long l) {
            }

            public void cancel() {
            }
        };
        private final Publisher<T> delegate;
        private final AtomicBoolean subscribed = new AtomicBoolean();

        public SingleSubscriberPublisher(Publisher<T> delegate) {
            this.delegate = delegate;
        }

        public void subscribe(Subscriber<? super T> subscriber) {
            Objects.requireNonNull(subscriber, "Subscriber is required");
            if (this.subscribed.compareAndSet(false, true)) {
                this.delegate.subscribe(subscriber);
            } else {
                subscriber.onSubscribe(NO_OP_SUBSCRIPTION);
                subscriber.onError((Throwable)new IllegalStateException("The client response body can only be consumed once"));
            }
        }
    }
}

