/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client.reactive;

import infra.core.AttributeAccessorSupport;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.client.reactive.ClientHttpRequest;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractClientHttpRequest
extends AttributeAccessorSupport
implements ClientHttpRequest {
    private final HttpHeaders headers;
    private final MultiValueMap<String, HttpCookie> cookies;
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final ArrayList<Supplier<? extends Publisher<Void>>> commitActions = new ArrayList(4);
    @Nullable
    private HttpHeaders readOnlyHeaders;

    public AbstractClientHttpRequest() {
        this(HttpHeaders.forWritable());
    }

    public AbstractClientHttpRequest(HttpHeaders headers) {
        Assert.notNull((Object)headers, (String)"HttpHeaders is required");
        this.headers = headers;
        this.cookies = MultiValueMap.forLinkedHashMap();
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.readOnlyHeaders != null) {
            return this.readOnlyHeaders;
        }
        if (State.COMMITTED.equals((Object)this.state.get())) {
            this.readOnlyHeaders = this.initReadOnlyHeaders();
            return this.readOnlyHeaders;
        }
        return this.headers;
    }

    protected HttpHeaders initReadOnlyHeaders() {
        return this.headers.asReadOnly();
    }

    @Override
    public MultiValueMap<String, HttpCookie> getCookies() {
        if (State.COMMITTED.equals((Object)this.state.get())) {
            return this.cookies.asReadOnly();
        }
        return this.cookies;
    }

    @Override
    public void beforeCommit(Supplier<? extends Mono<Void>> action) {
        Assert.notNull(action, (String)"Action is required");
        this.commitActions.add(action);
    }

    @Override
    public boolean isCommitted() {
        return this.state.get() != State.NEW;
    }

    protected Mono<Void> doCommit() {
        return this.doCommit(null);
    }

    protected Mono<Void> doCommit(@Nullable Supplier<? extends Publisher<Void>> writeAction) {
        if (!this.state.compareAndSet(State.NEW, State.COMMITTING)) {
            return Mono.empty();
        }
        this.commitActions.add(() -> Mono.fromRunnable(() -> {
            this.applyHeaders();
            this.applyCookies();
            this.applyAttributes();
            this.state.set(State.COMMITTED);
        }));
        if (writeAction != null) {
            this.commitActions.add(writeAction);
        }
        ArrayList<Publisher<Void>> actions = new ArrayList<Publisher<Void>>(this.commitActions.size());
        for (Supplier<? extends Publisher<Void>> commitAction : this.commitActions) {
            actions.add(commitAction.get());
        }
        return Flux.concat(actions).then();
    }

    protected abstract void applyHeaders();

    protected abstract void applyCookies();

    protected void applyAttributes() {
    }

    private static enum State {
        NEW,
        COMMITTING,
        COMMITTED;

    }
}

